"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiStat = exports.COLORS = exports.ALIGNMENTS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _text = require("../text");
var _title = require("../title/title");
var _i18n = require("../i18n");
var _services = require("../../services");
var _stat = require("./stat.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "description", "isLoading", "reverse", "textAlign", "title", "titleColor", "titleSize", "titleElement", "descriptionElement"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var COLORS = exports.COLORS = ['default', 'subdued', 'primary', 'success', 'danger', 'accent'];
var ALIGNMENTS = exports.ALIGNMENTS = ['left', 'center', 'right'];
var EuiStat = exports.EuiStat = function EuiStat(_ref) {
  var children = _ref.children,
    className = _ref.className,
    description = _ref.description,
    _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
    _ref$reverse = _ref.reverse,
    reverse = _ref$reverse === void 0 ? false : _ref$reverse,
    _ref$textAlign = _ref.textAlign,
    textAlign = _ref$textAlign === void 0 ? 'left' : _ref$textAlign,
    title = _ref.title,
    _ref$titleColor = _ref.titleColor,
    titleColor = _ref$titleColor === void 0 ? 'default' : _ref$titleColor,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 'l' : _ref$titleSize,
    _ref$titleElement = _ref.titleElement,
    titleElement = _ref$titleElement === void 0 ? 'p' : _ref$titleElement,
    _ref$descriptionEleme = _ref.descriptionElement,
    descriptionElement = _ref$descriptionEleme === void 0 ? 'p' : _ref$descriptionEleme,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiStat', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_stat.euiStatStyles);
  var cssStyles = [styles.euiStat, styles[textAlign]];
  var loadingStatsAriaLabel = (0, _i18n.useEuiI18n)('euiStat.loadingText', 'Statistic is loading');
  var titleStyles = (0, _services.useEuiMemoizedStyles)(_stat.euiStatTitleStyles);
  var titleDisplay = (0, _react.useMemo)(function () {
    var isNamedTitleColor = COLORS.includes(titleColor);
    var titleCssStyles = [titleStyles.euiStat__title, isNamedTitleColor && titleStyles[titleColor], isLoading && titleStyles.isLoading];
    return (0, _react2.jsx)(_title.EuiTitle, {
      size: titleSize,
      className: "euiStat__title",
      css: titleCssStyles,
      "aria-label": isLoading ? loadingStatsAriaLabel : undefined
    }, /*#__PURE__*/(0, _react.createElement)(titleElement, isNamedTitleColor ? null : {
      style: {
        color: titleColor
      }
    }, isLoading ? '--' : title));
  }, [title, titleElement, titleColor, titleSize, titleStyles, isLoading, loadingStatsAriaLabel]);
  var descriptionDisplay = (0, _react.useMemo)(function () {
    return (0, _react2.jsx)(_text.EuiText, {
      size: "s",
      className: "euiStat__description"
    }, /*#__PURE__*/(0, _react.createElement)(descriptionElement, null, description));
  }, [description, descriptionElement]);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), !reverse && descriptionDisplay, titleDisplay, reverse && descriptionDisplay, children);
};
EuiStat.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Set the description (label) text
     */
  description: _propTypes.default.node.isRequired,
  /**
     * Will hide the title with an animation until false
     */
  isLoading: _propTypes.default.bool,
  /**
     * Flips the order of the description and title
     */
  reverse: _propTypes.default.bool,
  textAlign: _propTypes.default.any,
  /**
     * The (value) text
     */
  title: _propTypes.default.node.isRequired,
  /**
     * The color of the title text
     */
  titleColor: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired]),
  /**
     * Size of the title. See EuiTitle for options ('s', 'm', 'l'... etc)
     */
  titleSize: _propTypes.default.any,
  /**
     * HTML Element to be used for title
     */
  titleElement: _propTypes.default.string,
  /**
     * HTML Element to be used for description
     */
  descriptionElement: _propTypes.default.string
};