"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiStatTitleStyles = exports.euiStatStyles = void 0;
var _taggedTemplateLiteral2 = _interopRequireDefault(require("@babel/runtime/helpers/taggedTemplateLiteral"));
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _templateObject;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiStatStyles = exports.euiStatStyles = function euiStatStyles() {
  return {
    euiStat: /*#__PURE__*/(0, _react.css)(";label:euiStat;"),
    // Text align
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('left'), " align-items:flex-start;;label:left;"),
    center: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('center'), " align-items:center;;label:center;"),
    right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('right'), " align-items:flex-end;;label:right;")
  };
};
var euiStatTitleStyles = exports.euiStatTitleStyles = function euiStatTitleStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiStat__title: /*#__PURE__*/(0, _react.css)(";label:euiStat__title;"),
    // Colors
    default: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.fullShade, ";;label:default;"),
    subdued: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.subduedText, ";;label:subdued;"),
    primary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.primaryText, ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.successText, ";;label:success;"),
    danger: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.dangerText, ";;label:danger;"),
    accent: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.accentText, ";;label:accent;"),
    // Loading
    isLoading: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{animation:", euiStatPulse, " 1.5s infinite ease-in-out;};label:isLoading;")
  };
};
var euiStatPulse = (0, _react.keyframes)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n  0% { opacity: 1; }\n  50% { opacity: .25; }\n  100% { opacity: 1; }\n"])));