"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiStep = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _title = require("../title");
var _step_number = require("./step_number");
var _services = require("../../services");
var _step = require("./step.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "children", "headingElement", "step", "title", "titleSize", "status"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiStep = exports.EuiStep = function EuiStep(_ref) {
  var className = _ref.className,
    children = _ref.children,
    _ref$headingElement = _ref.headingElement,
    headingElement = _ref$headingElement === void 0 ? 'p' : _ref$headingElement,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    title = _ref.title,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    status = _ref.status,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiStep', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _step.euiStepStyles)(euiTheme);
  var cssStyles = [styles.euiStep, styles[titleSize]];
  var contentStyles = (0, _step.euiStepContentStyles)(euiTheme);
  var cssContentStyles = [contentStyles.euiStep__content, contentStyles[titleSize]];
  var titleStyles = (0, _step.euiStepTitleStyles)(euiTheme);
  var cssStepTitleStyles = [titleStyles.euiStep__title, status === 'disabled' && titleStyles.isDisabled, titleStyles[titleSize]];
  var cssTitleWrapperStyles = titleStyles.euiStep__titleWrapper;
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, rest), (0, _react2.jsx)("div", {
    className: "euiStep__titleWrapper",
    css: cssTitleWrapperStyles
  }, (0, _react2.jsx)(_step_number.EuiStepNumber, {
    number: step,
    status: status,
    titleSize: titleSize === 'xxs' ? 'none' : titleSize
  }), (0, _react2.jsx)(_title.EuiTitle, {
    size: titleSize === 'xxs' ? 'xs' : titleSize,
    className: "euiStep__title",
    css: cssStepTitleStyles
  }, /*#__PURE__*/(0, _react.createElement)(headingElement, null, title))), (0, _react2.jsx)("div", {
    className: "euiStep__content",
    css: cssContentStyles
  }, children));
};
EuiStep.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node.isRequired,
  /**
     * The HTML tag used for the title
     */
  headingElement: _propTypes.default.string,
  /**
     * The number of the step in the list of steps
     */
  step: _propTypes.default.number,
  title: _propTypes.default.string.isRequired,
  /**
     * May replace the number provided in props.step with alternate styling.
     */
  status: _propTypes.default.any,
  /**
     * Title sizing equivalent to **EuiTitle**, but only `m`, `s`, `xs` font sizes.
     * The `xxs` size reduces the size of the accompanying step indicator, but not the title itself.
     * @default s
     */
  titleSize: _propTypes.default.any
};