"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiStepHorizontal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _services = require("../../services");
var _step_number = require("./step_number");
var _step_strings = require("./step_strings");
var _step_horizontal = require("./step_horizontal.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "step", "title", "onClick", "disabled", "status", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// The titleSize map is not 1 to 1; small == xs on the titleSize map
var stepNumberSizeMap = {
  xs: 'none',
  s: 'xs',
  m: 'm'
};
var EuiStepHorizontal = exports.EuiStepHorizontal = function EuiStepHorizontal(_ref) {
  var className = _ref.className,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    title = _ref.title,
    onClick = _ref.onClick,
    disabled = _ref.disabled,
    _ref$status = _ref.status,
    status = _ref$status === void 0 ? 'incomplete' : _ref$status,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  if (disabled) status = 'disabled';
  var classes = (0, _classnames.default)('euiStepHorizontal', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _step_horizontal.euiStepHorizontalStyles)(euiTheme);
  var cssStyles = [styles.euiStepHorizontal, styles[size], status === 'disabled' ? styles.disabled : styles.enabled];
  var numberStyles = (0, _step_horizontal.euiStepHorizontalNumberStyles)(euiTheme);
  var cssNumberStyles = [numberStyles.euiStepHorizontal__number];
  var titleStyles = (0, _step_horizontal.euiStepHorizontalTitleStyles)(euiTheme);
  var cssTitleStyles = [titleStyles.euiStepHorizontal__title, status === 'disabled' && titleStyles.disabled];
  var titleAttrsMap = {
    step: (0, _step_strings.useI18nStep)({
      number: step,
      title: title
    }),
    current: (0, _step_strings.useI18nCurrentStep)({
      number: step,
      title: title
    }),
    disabled: (0, _step_strings.useI18nDisabledStep)({
      number: step,
      title: title
    }),
    incomplete: (0, _step_strings.useI18nIncompleteStep)({
      number: step,
      title: title
    }),
    complete: (0, _step_strings.useI18nCompleteStep)({
      number: step,
      title: title
    }),
    warning: (0, _step_strings.useI18nWarningStep)({
      number: step,
      title: title
    }),
    danger: (0, _step_strings.useI18nErrorsStep)({
      number: step,
      title: title
    }),
    loading: (0, _step_strings.useI18nLoadingStep)({
      number: step,
      title: title
    })
  };
  var titleAttr = titleAttrsMap[status || 'step'];
  var onStepClick = function onStepClick(event) {
    if (!disabled) onClick(event);
  };
  return (0, _react2.jsx)("button", (0, _extends2.default)({
    "aria-disabled": status === 'disabled' ? true : undefined,
    className: classes,
    title: titleAttr,
    onClick: onStepClick,
    disabled: disabled,
    css: cssStyles,
    "data-step-status": status
  }, rest), (0, _react2.jsx)(_step_number.EuiStepNumber, {
    className: "euiStepHorizontal__number",
    status: status,
    number: step,
    titleSize: stepNumberSizeMap[size],
    css: cssNumberStyles
  }), (0, _react2.jsx)("span", {
    className: "euiStepHorizontal__title",
    css: cssTitleStyles
  }, title));
};
EuiStepHorizontal.propTypes = {
  onClick: _propTypes.default.func.isRequired,
  /**
     * Makes the whole step button disabled.
     */
  disabled: _propTypes.default.bool,
  /**
     * The number of the step in the list of steps
     */
  step: _propTypes.default.number,
  title: _propTypes.default.string,
  /**
     * Visual representation of the step number indicator.
     * May replace the number provided in props.step with alternate styling.
     * The `disabled` prop will override this.
     */
  status: _propTypes.default.any,
  size: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};