"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiStepsHorizontal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _step_horizontal = require("./step_horizontal");
var _steps_horizontal = require("./steps_horizontal.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "steps", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var SIZES = exports.SIZES = ['xs', 's', 'm'];
var EuiStepsHorizontal = exports.EuiStepsHorizontal = function EuiStepsHorizontal(_ref) {
  var className = _ref.className,
    steps = _ref.steps,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiStepsHorizontal', className);
  var styles = (0, _steps_horizontal.euiStepsHorizontalStyles)();
  var cssStyles = styles.euiStepsHorizontal;
  var cssItemStyles = styles.euiStepsHorizontal__item;
  return (0, _react2.jsx)("ol", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, rest), steps.map(function (stepProps, index) {
    return (0, _react2.jsx)("li", {
      key: index,
      className: "euiStepsHorizontal__item",
      css: cssItemStyles,
      "aria-current": stepProps.status === 'current' ? 'step' : undefined
    }, (0, _react2.jsx)(_step_horizontal.EuiStepHorizontal, (0, _extends2.default)({
      step: index + 1,
      size: size
    }, stepProps)));
  }));
};
EuiStepsHorizontal.propTypes = {
  /**
     * An array of `EuiStepHorizontal` objects excluding the `step` prop
     */
  steps: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
  size: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};