"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableSortMobile = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button_empty = require("../../button/button_empty");
var _popover = require("../../popover");
var _context_menu = require("../../context_menu");
var _i18n = require("../../i18n");
var _table_sort_mobile_item = require("./table_sort_mobile_item");
var _react2 = require("@emotion/react");
var _excluded = ["className", "anchorPosition", "items"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiTableSortMobile = exports.EuiTableSortMobile = /*#__PURE__*/function (_Component) {
  function EuiTableSortMobile() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiTableSortMobile);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiTableSortMobile, [].concat(args));
    (0, _defineProperty2.default)(_this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(_this, "onButtonClick", function () {
      _this.setState({
        isPopoverOpen: !_this.state.isPopoverOpen
      });
    });
    (0, _defineProperty2.default)(_this, "closePopover", function () {
      _this.setState({
        isPopoverOpen: false
      });
    });
    // Aligns the button to the right even when it's the only element present
    (0, _defineProperty2.default)(_this, "euiTableSortMobileStyles", {
      marginInlineStart: 'auto',
      label: 'euiTableSortMobile'
    });
    return _this;
  }
  (0, _inherits2.default)(EuiTableSortMobile, _Component);
  return (0, _createClass2.default)(EuiTableSortMobile, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        className = _this$props.className,
        anchorPosition = _this$props.anchorPosition,
        items = _this$props.items,
        rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var classes = (0, _classnames.default)('euiTableSortMobile', className);
      var mobileSortButton = (0, _react2.jsx)(_button_empty.EuiButtonEmpty, {
        iconType: "arrowDown",
        iconSide: "right",
        onClick: this.onButtonClick.bind(this),
        flush: "right",
        size: "xs"
      }, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTableSortMobile.sorting",
        default: "Sorting"
      }));
      var mobileSortPopover = (0, _react2.jsx)(_popover.EuiPopover, (0, _extends2.default)({
        button: mobileSortButton,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        anchorPosition: anchorPosition || 'downRight',
        panelPaddingSize: "none"
      }, rest), (0, _react2.jsx)(_context_menu.EuiContextMenuPanel, {
        style: {
          minWidth: 200
        },
        items: items && items.length ? items.map(function (item) {
          return (0, _react2.jsx)(_table_sort_mobile_item.EuiTableSortMobileItem, {
            key: item.key,
            onSort: item.onSort,
            isSorted: item.isSorted,
            isSortAscending: item.isSortAscending
          }, item.name);
        }) : undefined
      }));
      return (0, _react2.jsx)("div", {
        className: classes,
        css: this.euiTableSortMobileStyles
      }, mobileSortPopover);
    }
  }]);
}(_react.Component);
EuiTableSortMobile.propTypes = {
  anchorPosition: _propTypes.default.any,
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    name: _propTypes.default.node.isRequired,
    key: _propTypes.default.any,
    onSort: _propTypes.default.func,
    isSorted: _propTypes.default.bool,
    isSortAscending: _propTypes.default.bool
  }).isRequired),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};