"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableFooterCell = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _utils = require("./utils");
var _table_cell_content = require("./_table_cell_content");
var _table_cells_shared = require("./table_cells_shared.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "align", "className", "width", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiTableFooterCell = exports.EuiTableFooterCell = function EuiTableFooterCell(_ref) {
  var children = _ref.children,
    _ref$align = _ref.align,
    align = _ref$align === void 0 ? _services.LEFT_ALIGNMENT : _ref$align,
    className = _ref.className,
    width = _ref.width,
    style = _ref.style,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiTableFooterCell', className);
  var inlineStyles = (0, _utils.resolveWidthAsStyle)(style, width);
  var styles = (0, _services.useEuiMemoizedStyles)(_table_cells_shared.euiTableHeaderFooterCellStyles);
  return (0, _react2.jsx)("td", (0, _extends2.default)({
    css: styles.euiTableFooterCell,
    className: classes,
    style: inlineStyles
  }, rest), (0, _react2.jsx)(_table_cell_content.EuiTableCellContent, {
    align: align,
    truncateText: true,
    textOnly: true
  }, children));
};
EuiTableFooterCell.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  align: _propTypes.default.any,
  width: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired])
};