"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableRowCell = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _responsive_context = require("./mobile/responsive_context");
var _utils = require("./utils");
var _table_cell_content = require("./_table_cell_content");
var _table_row_cell = require("./table_row_cell.styles");
var _react2 = require("@emotion/react");
var _excluded = ["align", "children", "className", "truncateText", "setScopeRow", "textOnly", "hasActions", "isExpander", "style", "width", "valign", "mobileOptions", "append"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiTableRowCell = exports.EuiTableRowCell = function EuiTableRowCell(_ref) {
  var _ref$align = _ref.align,
    align = _ref$align === void 0 ? _services.LEFT_ALIGNMENT : _ref$align,
    children = _ref.children,
    className = _ref.className,
    truncateText = _ref.truncateText,
    setScopeRow = _ref.setScopeRow,
    _ref$textOnly = _ref.textOnly,
    textOnly = _ref$textOnly === void 0 ? true : _ref$textOnly,
    hasActions = _ref.hasActions,
    isExpander = _ref.isExpander,
    style = _ref.style,
    width = _ref.width,
    _ref$valign = _ref.valign,
    valign = _ref$valign === void 0 ? 'middle' : _ref$valign,
    mobileOptions = _ref.mobileOptions,
    append = _ref.append,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isResponsive = (0, _responsive_context.useEuiTableIsResponsive)();
  var styles = (0, _services.useEuiMemoizedStyles)(_table_row_cell.euiTableRowCellStyles);
  var cssStyles = [styles.euiTableRowCell, setScopeRow && styles.rowHeader, isExpander && styles.isExpander, hasActions && styles.hasActions, styles[valign]].concat((0, _toConsumableArray2.default)(isResponsive ? [styles.mobile.mobile, (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.enlarge) && styles.mobile.enlarge, hasActions === 'custom' && styles.mobile.customActions, hasActions === true && styles.mobile.actions, isExpander && styles.mobile.expander] : [styles.desktop.desktop, hasActions && styles.desktop.actions]));
  var cellClasses = (0, _classnames.default)('euiTableRowCell', className, {
    'euiTableRowCell--hasActions': hasActions,
    'euiTableRowCell--isExpander': isExpander
  });
  var widthValue = isResponsive ? hasActions || isExpander ? undefined // On mobile, actions are shifted to a right column via CSS
  : mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.width : width;
  var styleObj = (0, _utils.resolveWidthAsStyle)(style, widthValue);
  var Element = setScopeRow ? 'th' : 'td';
  var sharedProps = _objectSpread({
    scope: setScopeRow ? 'row' : undefined,
    style: styleObj,
    css: cssStyles
  }, rest);
  var sharedContentProps = {
    align: align,
    textOnly: textOnly,
    truncateText: truncateText,
    hasActions: hasActions || isExpander
  };
  if (isResponsive) {
    // Mobile view
    if ((mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.show) === false) {
      return null;
    } else {
      var _mobileOptions$align, _mobileOptions$trunca, _mobileOptions$textOn;
      return (0, _react2.jsx)(Element, (0, _extends2.default)({
        className: cellClasses
      }, sharedProps), (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.header) && (0, _react2.jsx)("div", {
        className: "euiTableRowCell__mobileHeader",
        css: styles.euiTableRowCell__mobileHeader
      }, mobileOptions.header), (0, _react2.jsx)(_table_cell_content.EuiTableCellContent, (0, _extends2.default)({}, sharedContentProps, {
        align: (_mobileOptions$align = mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.align) !== null && _mobileOptions$align !== void 0 ? _mobileOptions$align : 'left' // Default to left aligned mobile cells, unless consumers specifically set an alignment for mobile
        ,
        truncateText: (_mobileOptions$trunca = mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.truncateText) !== null && _mobileOptions$trunca !== void 0 ? _mobileOptions$trunca : truncateText,
        textOnly: (_mobileOptions$textOn = mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.textOnly) !== null && _mobileOptions$textOn !== void 0 ? _mobileOptions$textOn : textOnly
      }), (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.render) || children), append);
    }
  } else {
    // Desktop view
    if (mobileOptions !== null && mobileOptions !== void 0 && mobileOptions.only) {
      return null;
    } else {
      return (0, _react2.jsx)(Element, (0, _extends2.default)({
        className: cellClasses
      }, sharedProps), (0, _react2.jsx)(_table_cell_content.EuiTableCellContent, sharedContentProps, children), append);
    }
  }
};
EuiTableRowCell.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Vertical alignment of the content in the cell
     */
  valign: _propTypes.default.any,
  /**
     * Indicates whether the cell should be marked as the heading for its row
     */
  setScopeRow: _propTypes.default.bool,
  /**
     * Indicates if the cell is dedicated to row actions
     * (used for mobile styling and desktop action hover behavior)
     */
  hasActions: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["custom"])]),
  /**
     * Indicates if the column is dedicated as the expandable row toggle
     */
  isExpander: _propTypes.default.bool,
  /**
     * Mobile options for displaying differently at small screens;
     * See #EuiTableRowCellMobileOptionsShape
     */
  mobileOptions: _propTypes.default.shape({
    /**
       * If false, will not render the cell at all for mobile
       * @default true
       */
    show: _propTypes.default.bool,
    /**
       * Only show for mobile? If true, will not render the column at all for desktop
       * @default false
       */
    only: _propTypes.default.bool,
    /**
       * Custom render/children if different from desktop
       */
    render: _propTypes.default.node,
    /**
       * The column's header for use in mobile view (automatically passed down
       * when using `EuiBasicTable`).
       * Or pass `false` to not show a header at all.
       */
    header: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.bool.isRequired]),
    /**
       * Increase text size compared to rest of cells
       * @default false
       */
    enlarge: _propTypes.default.bool,
    /**
       * Applies the value to the width of the cell in mobile view (typically 50%)
       * @default 50%
       */
    width: _propTypes.default.any,
    /**
       * Horizontal alignment of the text in the cell
       */
    align: _propTypes.default.any,
    /**
       * Creates a text wrapper around cell content that helps word break or truncate
       * long text correctly.
       * @default true
       */
    textOnly: _propTypes.default.bool,
    /**
       * Indicates whether this column should truncate overflowing text content.
       * - Set to `true` to enable single-line truncation.
       * - To enable multi-line truncation, use a configuration object with `lines`
       * set to a number of lines to truncate to.
       * @default false
       */
    truncateText: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
      lines: _propTypes.default.number.isRequired
    }).isRequired])
  }),
  /**
     * Content rendered outside the visible cell content wrapper. Useful for, e.g. screen reader text.
     *
     * Used by EuiBasicTable to render hidden copy markers
     */
  append: _propTypes.default.node,
  /**
     * Horizontal alignment of the text in the cell
     */
  align: _propTypes.default.any,
  /**
     * Creates a text wrapper around cell content that helps word break or truncate
     * long text correctly.
     * @default true
     */
  textOnly: _propTypes.default.bool,
  /**
     * Indicates whether this column should truncate overflowing text content.
     * - Set to `true` to enable single-line truncation.
     * - To enable multi-line truncation, use a configuration object with `lines`
     * set to a number of lines to truncate to.
     * @default false
     */
  truncateText: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    lines: _propTypes.default.number.isRequired
  }).isRequired]),
  width: _propTypes.default.any
};