"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTab = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _href_validator = require("../../services/security/href_validator");
var _tab = require("./tab.styles");
var _tabs_context = require("./tabs_context");
var _react2 = require("@emotion/react");
var _excluded = ["isSelected", "children", "className", "disabled", "href", "target", "rel", "prepend", "append"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiTab = exports.EuiTab = function EuiTab(_ref) {
  var isSelected = _ref.isSelected,
    children = _ref.children,
    className = _ref.className,
    _disabled = _ref.disabled,
    href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    prepend = _ref.prepend,
    append = _ref.append,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_tabs_context.EuiTabsContext),
    size = _useContext.size,
    expand = _useContext.expand;
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  var disabled = _disabled || !isHrefValid;

  // Keep CSS classnames for reference
  var classes = (0, _classnames.default)('euiTab', className, {
    'euiTab-isSelected': isSelected
  });
  var tabStyles = (0, _services.useEuiMemoizedStyles)(_tab.euiTabStyles);
  var cssTabStyles = [tabStyles.euiTab, expand && tabStyles.expanded, disabled && tabStyles.disabled.disabled, isSelected && (disabled ? tabStyles.disabled.selected : tabStyles.selected)];
  var tabContentStyles = (0, _services.useEuiMemoizedStyles)(_tab.euiTabContentStyles);
  var cssTabContentStyles = [tabContentStyles.euiTab__content, size && tabContentStyles[size]];
  var prependNode = prepend && (0, _react2.jsx)("span", {
    className: "euiTab__prepend"
  }, prepend);
  var appendNode = append && (0, _react2.jsx)("span", {
    className: "euiTab__append"
  }, append);

  //  <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
  //  this is a button and piggyback off its disabled styles.
  if (href && !disabled) {
    var secureRel = (0, _services.getSecureRelForTarget)({
      href: href,
      target: target,
      rel: rel
    });
    return (0, _react2.jsx)("a", (0, _extends2.default)({
      role: "tab",
      "aria-selected": !!isSelected,
      tabIndex: isSelected ? 0 : -1,
      className: classes,
      css: cssTabStyles,
      href: href,
      target: target,
      rel: secureRel
    }, rest), prependNode, (0, _react2.jsx)("span", {
      className: "euiTab__content eui-textTruncate",
      css: cssTabContentStyles
    }, children), appendNode);
  }
  return (0, _react2.jsx)("button", (0, _extends2.default)({
    role: "tab",
    "aria-selected": !!isSelected,
    tabIndex: isSelected ? 0 : -1,
    type: "button",
    className: classes,
    css: cssTabStyles,
    disabled: disabled
  }, rest), prependNode, (0, _react2.jsx)("span", {
    className: "euiTab__content eui-textTruncate",
    css: cssTabContentStyles
  }, children), appendNode);
};
EuiTab.propTypes = {
  isSelected: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  /**
     * Places content before the tab content/children.
     * Will be excluded from interactive effects.
     */
  /**
     * Places content before the tab content/children.
     * Will be excluded from interactive effects.
     */
  prepend: _propTypes.default.node,
  /**
     * Places content after the tab content/children.
     * Will be excluded from interactive effects.
     */
  /**
     * Places content after the tab content/children.
     * Will be excluded from interactive effects.
     */
  append: _propTypes.default.node,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  href: _propTypes.default.string,
  onClick: _propTypes.default.func
};