"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTextAlign = exports.ALIGNMENTS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _text_align = require("./text_align.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "component", "textAlign", "cloneElement"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ALIGNMENTS = exports.ALIGNMENTS = ['left', 'right', 'center'];
var EuiTextAlign = exports.EuiTextAlign = function EuiTextAlign(_ref) {
  var children = _ref.children,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    _ref$textAlign = _ref.textAlign,
    textAlign = _ref$textAlign === void 0 ? 'left' : _ref$textAlign,
    _ref$cloneElement = _ref.cloneElement,
    cloneElement = _ref$cloneElement === void 0 ? false : _ref$cloneElement,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var cssStyles = [_text_align.euiTextAlignStyles.euiTextAlign, _text_align.euiTextAlignStyles[textAlign]];
  var props = _objectSpread({
    css: cssStyles
  }, rest);
  if ( /*#__PURE__*/(0, _react.isValidElement)(children) && cloneElement) {
    return (0, _services.cloneElementWithCss)(children, props);
  } else {
    return (0, _react2.jsx)(Component, props, children);
  }
};
EuiTextAlign.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * The HTML element/tag to render.
       * Use with care when nesting multiple components to ensure valid XHTML:
       * - `<div>` and other block tags are not valid to use inside `<p>`. If using the `<p>` tag, we recommend passing strings/text only.
       * - `<span>` is valid to be nested in any tag, and can have any tag nested within it.
       */
  component: _propTypes.default.oneOf(["div", "span", "p"]),
  /**
     * Applies text styling to the child element instead of rendering a parent wrapper.
     * Can only be used when wrapping a *single* child element/tag, and not raw text.
     */
  cloneElement: _propTypes.default.bool,
  /**
     * Applies horizontal text alignment
     * @default left
     */
  textAlign: _propTypes.default.any
};