"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._isNamedColor = exports.EuiTextColor = exports.COLORS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _text_color = require("./text_color.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "color", "component", "cloneElement", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var COLORS = exports.COLORS = ['default', 'subdued', 'success', 'accent', 'danger', 'warning', 'ghost', 'inherit'];
var _isNamedColor = exports._isNamedColor = function _isNamedColor(color) {
  return COLORS.includes(color);
};
var EuiTextColor = exports.EuiTextColor = function EuiTextColor(_ref) {
  var children = _ref.children,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'default' : _ref$color,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'span' : _ref$component,
    _ref$cloneElement = _ref.cloneElement,
    cloneElement = _ref$cloneElement === void 0 ? false : _ref$cloneElement,
    style = _ref.style,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isNamedColor = _isNamedColor(color);
  var styles = (0, _services.useEuiMemoizedStyles)(_text_color.euiTextColorStyles);
  var cssStyles = [styles.euiTextColor, isNamedColor ? styles[color] : styles.customColor];

  // We're checking if is a custom color.
  // If it is a custom color we set the `color` of the `.euiTextColor` div to that custom color.
  // This way the children text elements can `inherit` that color and border and backgrounds can get that `currentColor`.
  var euiTextStyle = !isNamedColor ? _objectSpread({
    color: color
  }, style) : _objectSpread({}, style);
  var props = _objectSpread({
    css: cssStyles,
    style: euiTextStyle
  }, rest);
  if ( /*#__PURE__*/(0, _react.isValidElement)(children) && cloneElement) {
    var childrenStyle = _objectSpread(_objectSpread({}, children.props.style), euiTextStyle);
    return (0, _services.cloneElementWithCss)(children, _objectSpread(_objectSpread({}, props), {}, {
      style: childrenStyle
    }));
  } else {
    return (0, _react2.jsx)(Component, props, children);
  }
};
EuiTextColor.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * The HTML element/tag to render.
       * Use with care when nesting multiple components to ensure valid XHTML:
       * - `<div>` and other block tags are not valid to use inside `<p>`. If using the `<p>` tag, we recommend passing strings/text only.
       * - `<span>` is valid to be nested in any tag, and can have any tag nested within it.
       */
  component: _propTypes.default.oneOf(["div", "span", "p"]),
  /**
     * Applies text styling to the child element instead of rendering a parent wrapper.
     * Can only be used when wrapping a *single* child element/tag, and not raw text.
     */
  cloneElement: _propTypes.default.bool,
  /**
     * Any of our named colors or a `hex`, `rgb` or `rgba` value.
     * @default inherit
     */
  color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired])
};