"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GUTTER_SIZES = exports.EuiTimeline = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _timeline_item = require("./timeline_item");
var _timeline = require("./timeline.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "items", "children", "gutterSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var GUTTER_SIZES = exports.GUTTER_SIZES = ['m', 'l', 'xl'];
var EuiTimeline = exports.EuiTimeline = function EuiTimeline(_ref) {
  var className = _ref.className,
    _ref$items = _ref.items,
    items = _ref$items === void 0 ? [] : _ref$items,
    children = _ref.children,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'xl' : _ref$gutterSize,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiTimeline', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _timeline.euiTimelineStyles)(euiTheme);
  var cssStyles = [styles.euiTimeline, styles[gutterSize]];
  return (
    // eslint-disable-next-line jsx-a11y/no-redundant-roles
    (0, _react2.jsx)("ol", (0, _extends2.default)({
      className: classes,
      css: cssStyles,
      role: "list"
    }, rest), items.map(function (item, index) {
      return (0, _react2.jsx)(_timeline_item.EuiTimelineItem, (0, _extends2.default)({
        key: index
      }, item));
    }), children)
  );
};
EuiTimeline.propTypes = {
  /**
     * List of timeline items to render. See #EuiTimelineItem
     */
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Vertical alignment of the event with the icon
       */
    verticalAlign: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired),
  /**
     * Sets the size of the vertical space between each timeline item
     */
  gutterSize: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};