"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POSITIONS = exports.EuiToolTip = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _react2 = require("../../services/react");
var _resize_observer = require("../observer/resize_observer");
var _portal = require("../portal");
var _tool_tip_popover = require("./tool_tip_popover");
var _tool_tip_anchor = require("./tool_tip_anchor");
var _tool_tip_arrow = require("./tool_tip_arrow");
var _tool_tip_manager = require("./tool_tip_manager");
var _react3 = require("@emotion/react");
var _excluded = ["children", "className", "anchorClassName", "anchorProps", "content", "title", "delay", "display", "repositionOnScroll"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var POSITIONS = exports.POSITIONS = ['top', 'right', 'bottom', 'left'];
var DISPLAYS = ['inlineBlock', 'block'];
var delayToMsMap = {
  regular: 250,
  long: 250 * 5
};
var DEFAULT_TOOLTIP_STYLES = {
  // position the tooltip content near the top-left
  // corner of the window so it can't create scrollbars
  // 50,50 because who knows what negative margins, padding, etc
  top: 50,
  left: 50,
  // just in case, avoid any potential flicker by hiding
  // the tooltip before it is positioned
  opacity: 0,
  // prevent accidental mouse interaction while positioning
  visibility: 'hidden'
};
var EuiToolTip = exports.EuiToolTip = /*#__PURE__*/function (_Component) {
  function EuiToolTip() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiToolTip);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiToolTip, [].concat(args));
    (0, _defineProperty2.default)(_this, "_isMounted", false);
    (0, _defineProperty2.default)(_this, "anchor", null);
    (0, _defineProperty2.default)(_this, "popover", null);
    (0, _defineProperty2.default)(_this, "timeoutId", void 0);
    (0, _defineProperty2.default)(_this, "state", {
      visible: false,
      hasFocus: false,
      calculatedPosition: _this.props.position,
      toolTipStyles: DEFAULT_TOOLTIP_STYLES,
      arrowStyles: undefined,
      id: _this.props.id || (0, _services.htmlIdGenerator)()()
    });
    (0, _defineProperty2.default)(_this, "clearAnimationTimeout", function () {
      if (_this.timeoutId) {
        _this.timeoutId = clearTimeout(_this.timeoutId);
      }
    });
    (0, _defineProperty2.default)(_this, "testAnchor", function () {
      // when the tooltip is visible, this checks if the anchor is still part of document
      // this fixes when the react root is removed from the dom without unmounting
      // https://github.com/elastic/eui/issues/1105
      if (document.body.contains(_this.anchor) === false) {
        // the anchor is no longer part of `document`
        _this.hideToolTip();
      } else {
        if (_this.state.visible) {
          // if still visible, keep checking
          requestAnimationFrame(_this.testAnchor);
        }
      }
    });
    (0, _defineProperty2.default)(_this, "setAnchorRef", function (ref) {
      return _this.anchor = ref;
    });
    (0, _defineProperty2.default)(_this, "setPopoverRef", function (ref) {
      return _this.popover = ref;
    });
    (0, _defineProperty2.default)(_this, "showToolTip", function () {
      if (!_this.timeoutId) {
        _this.timeoutId = setTimeout(function () {
          (0, _react2.enqueueStateChange)(function () {
            _this.setState({
              visible: true
            });
            _tool_tip_manager.toolTipManager.registerTooltip(_this.hideToolTip);
          });
        }, delayToMsMap[_this.props.delay]);
      }
    });
    (0, _defineProperty2.default)(_this, "positionToolTip", function () {
      var requestedPosition = _this.props.position;
      if (!_this.anchor || !_this.popover) {
        return;
      }
      var _findPopoverPosition = (0, _services.findPopoverPosition)({
          anchor: _this.anchor,
          popover: _this.popover,
          position: requestedPosition,
          offset: 16,
          // offset popover 16px from the anchor
          arrowConfig: {
            arrowWidth: 12,
            arrowBuffer: 4
          }
        }),
        position = _findPopoverPosition.position,
        left = _findPopoverPosition.left,
        top = _findPopoverPosition.top,
        arrow = _findPopoverPosition.arrow;

      // If encroaching the right edge of the window:
      // When `props.content` changes and is longer than `prevProps.content`, the tooltip width remains and
      // the resizeObserver callback will fire twice (once for vertical resize caused by text line wrapping,
      // once for a subsequent position correction) and cause a flash rerender and reposition.
      // To prevent this, we can orient from the right so that text line wrapping does not occur, negating
      // the second resizeObserver callback call.
      var windowWidth = document.documentElement.clientWidth || window.innerWidth;
      var useRightValue = windowWidth / 2 < left;
      var toolTipStyles = {
        top: top,
        left: useRightValue ? 'auto' : left,
        right: useRightValue ? windowWidth - left - _this.popover.offsetWidth : 'auto'
      };
      _this.setState({
        visible: true,
        calculatedPosition: position,
        toolTipStyles: toolTipStyles,
        arrowStyles: arrow
      });
    });
    (0, _defineProperty2.default)(_this, "hideToolTip", function () {
      _this.clearAnimationTimeout();
      (0, _react2.enqueueStateChange)(function () {
        if (_this._isMounted) {
          _this.setState({
            visible: false,
            toolTipStyles: DEFAULT_TOOLTIP_STYLES,
            arrowStyles: undefined
          });
          _tool_tip_manager.toolTipManager.deregisterToolTip(_this.hideToolTip);
        }
      });
    });
    (0, _defineProperty2.default)(_this, "onFocus", function () {
      _this.setState({
        hasFocus: true
      });
      _this.showToolTip();
    });
    (0, _defineProperty2.default)(_this, "onBlur", function () {
      _this.setState({
        hasFocus: false
      });
      _this.hideToolTip();
    });
    (0, _defineProperty2.default)(_this, "onEscapeKey", function (event) {
      if (event.key === _services.keys.ESCAPE) {
        if (_this.state.visible) event.stopPropagation();
        _this.setState({
          hasFocus: false
        }); // Allows mousing over back into the tooltip to work correctly
        _this.hideToolTip();
      }
    });
    (0, _defineProperty2.default)(_this, "onMouseOut", function (event) {
      // Prevent mousing over children from hiding the tooltip by testing for whether the mouse has
      // left the anchor for a non-child.
      if (_this.anchor === event.relatedTarget || _this.anchor != null && !_this.anchor.contains(event.relatedTarget)) {
        if (!_this.state.hasFocus) {
          _this.hideToolTip();
        }
      }
      if (_this.props.onMouseOut) {
        _this.props.onMouseOut(event);
      }
    });
    return _this;
  }
  (0, _inherits2.default)(EuiToolTip, _Component);
  return (0, _createClass2.default)(EuiToolTip, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
      if (this.props.repositionOnScroll) {
        window.addEventListener('scroll', this.positionToolTip, true);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.clearAnimationTimeout();
      this._isMounted = false;
      window.removeEventListener('scroll', this.positionToolTip, true);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (prevState.visible === false && this.state.visible === true) {
        requestAnimationFrame(this.testAnchor);
      }

      // update scroll listener
      if (prevProps.repositionOnScroll !== this.props.repositionOnScroll) {
        if (this.props.repositionOnScroll) {
          window.addEventListener('scroll', this.positionToolTip, true);
        } else {
          window.removeEventListener('scroll', this.positionToolTip, true);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        anchorClassName = _this$props.anchorClassName,
        anchorProps = _this$props.anchorProps,
        content = _this$props.content,
        title = _this$props.title,
        delay = _this$props.delay,
        display = _this$props.display,
        repositionOnScroll = _this$props.repositionOnScroll,
        rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var _this$state = this.state,
        arrowStyles = _this$state.arrowStyles,
        id = _this$state.id,
        toolTipStyles = _this$state.toolTipStyles,
        visible = _this$state.visible,
        calculatedPosition = _this$state.calculatedPosition;
      var classes = (0, _classnames.default)('euiToolTip', className);
      var anchorClasses = (0, _classnames.default)(anchorClassName, anchorProps === null || anchorProps === void 0 ? void 0 : anchorProps.className);
      return (0, _react3.jsx)(_react.default.Fragment, null, (0, _react3.jsx)(_tool_tip_anchor.EuiToolTipAnchor, (0, _extends2.default)({}, anchorProps, {
        ref: this.setAnchorRef,
        onBlur: this.onBlur,
        onFocus: this.onFocus,
        onKeyDown: this.onEscapeKey,
        onMouseOver: this.showToolTip,
        onMouseOut: this.onMouseOut,
        id: id,
        className: anchorClasses,
        display: display,
        isVisible: visible
      }), children), visible && (content || title) && (0, _react3.jsx)(_portal.EuiPortal, null, (0, _react3.jsx)(_tool_tip_popover.EuiToolTipPopover, (0, _extends2.default)({
        className: classes,
        style: toolTipStyles,
        positionToolTip: this.positionToolTip,
        popoverRef: this.setPopoverRef,
        title: title,
        id: id,
        role: "tooltip",
        calculatedPosition: calculatedPosition
      }, rest), (0, _react3.jsx)(_tool_tip_arrow.EuiToolTipArrow, {
        style: arrowStyles,
        className: "euiToolTip__arrow",
        position: calculatedPosition
      }), (0, _react3.jsx)(_resize_observer.EuiResizeObserver, {
        onResize: this.positionToolTip
      }, function (resizeRef) {
        return (0, _react3.jsx)("div", {
          ref: resizeRef
        }, content);
      }))));
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiToolTip, "defaultProps", {
  position: 'top',
  delay: 'regular',
  display: 'inlineBlock'
});
EuiToolTip.propTypes = {
  /**
     * Passes onto the span wrapping the trigger.
     */
  anchorClassName: _propTypes.default.string,
  /**
     * Passes onto the span wrapping the trigger.
     */
  anchorProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  /**
     * The in-view trigger for your tooltip.
     */
  children: _propTypes.default.element.isRequired,
  /**
     * Passes onto the tooltip itself, not the trigger.
     */
  className: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string]),
  /**
     * The main content of your tooltip.
     */
  content: _propTypes.default.node,
  /**
     * Common display alternatives for the anchor wrapper
     */
  display: _propTypes.default.any,
  /**
     * Delay before showing tooltip. Good for repeatable items.
     */
  delay: _propTypes.default.oneOf(["regular", "long"]).isRequired,
  /**
     * An optional title for your tooltip.
     */
  title: _propTypes.default.node,
  /**
     * Unless you provide one, this will be randomly generated.
     */
  id: _propTypes.default.string,
  /**
     * Suggested position. If there is not enough room for it this will be changed.
     */
  position: _propTypes.default.oneOf(["top", "right", "bottom", "left"]).isRequired,
  /**
     * When `true`, the tooltip's position is re-calculated when the user
     * scrolls. This supports having fixed-position tooltip anchors.
     *
     * When nesting an `EuiTooltip` in a scrollable container, `repositionOnScroll` should be `true`
     */
  repositionOnScroll: _propTypes.default.bool,
  /**
     * If supplied, called when mouse movement causes the tool tip to be
     * hidden.
     */
  onMouseOut: _propTypes.default.func,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};