"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourStep = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _popover = require("../popover");
var _beacon = require("../beacon");
var _tour_header = require("./_tour_header");
var _tour_footer = require("./_tour_footer");
var _tour = require("./tour.styles");
var _react2 = require("@emotion/react");
var _excluded = ["anchorPosition", "anchor", "children", "className", "css", "closePopover", "content", "isStepOpen", "minWidth", "maxWidth", "onFinish", "step", "stepsTotal", "subtitle", "title", "decoration", "footerAction", "panelProps", "panelClassName"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiTourStep = exports.EuiTourStep = function EuiTourStep(_ref) {
  var _ref$anchorPosition = _ref.anchorPosition,
    anchorPosition = _ref$anchorPosition === void 0 ? 'leftUp' : _ref$anchorPosition,
    anchor = _ref.anchor,
    children = _ref.children,
    className = _ref.className,
    css = _ref.css,
    _ref$closePopover = _ref.closePopover,
    closePopover = _ref$closePopover === void 0 ? function () {} : _ref$closePopover,
    content = _ref.content,
    _ref$isStepOpen = _ref.isStepOpen,
    isStepOpen = _ref$isStepOpen === void 0 ? false : _ref$isStepOpen,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 300 : _ref$minWidth,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? 600 : _ref$maxWidth,
    onFinish = _ref.onFinish,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    stepsTotal = _ref.stepsTotal,
    subtitle = _ref.subtitle,
    title = _ref.title,
    _ref$decoration = _ref.decoration,
    decoration = _ref$decoration === void 0 ? 'beacon' : _ref$decoration,
    footerAction = _ref.footerAction,
    panelProps = _ref.panelProps,
    panelClassName = _ref.panelClassName,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var titleId = (0, _services.useGeneratedHtmlId)();
  if (step === 0) {
    console.warn('EuiTourStep `step` should use 1-based indexing. Please update to eliminate 0 indexes.');
  }
  var _useState = (0, _react.useState)(null),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    anchorNode = _useState2[0],
    setAnchorNode = _useState2[1];
  var _useState3 = (0, _react.useState)(),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    popoverPosition = _useState4[0],
    setPopoverPosition = _useState4[1];
  var onPositionChange = (0, _react.useCallback)(function (position) {
    setPopoverPosition(position);
  }, []);
  (0, _react.useEffect)(function () {
    if (anchor) {
      // Wait until next tick to find anchor node in case it's not already
      // in DOM requestAnimationFrame isn't used here because we don't need to
      // synchronize with repainting ticks and the updated value still
      // needs to go through a react DOM rerender which may take more than
      // 1 frame (16ms) of time.
      // TODO: It would be ideal to have some kind of intersection observer here instead
      var timeout = window.setTimeout(function () {
        setAnchorNode((0, _services.findElementBySelectorOrRef)(anchor));
      });
      return function () {
        return window.clearTimeout(timeout);
      };
    }
  }, [anchor]);
  var anchorClasses = (0, _classnames.default)('euiTourAnchor', className);
  var popoverClasses = (0, _classnames.default)('euiTour', panelClassName);
  var tourStyles = (0, _services.useEuiMemoizedStyles)(_tour.euiTourStyles);
  var beaconStyles = (0, _services.useEuiMemoizedStyles)(_tour.euiTourBeaconStyles);
  var beaconCss = [beaconStyles.euiTourBeacon, isStepOpen && beaconStyles.isOpen, popoverPosition && beaconStyles[popoverPosition]];
  var hasBeacon = decoration === 'beacon';
  var widthStyles = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)({
      minWidth: minWidth,
      maxWidth: maxWidth
    });
  }, [minWidth, maxWidth]);
  var noAnchor = !anchor && children;
  var PopoverComponent = noAnchor ? _popover.EuiPopover : _popover.EuiWrappingPopover;
  var button = noAnchor ? children : anchorNode;
  return button ? (0, _react2.jsx)(PopoverComponent, (0, _extends2.default)({
    button: button,
    className: anchorClasses,
    anchorPosition: anchorPosition,
    closePopover: closePopover,
    isOpen: isStepOpen,
    ownFocus: false,
    panelClassName: popoverClasses,
    panelProps: _objectSpread(_objectSpread({}, panelProps), {}, {
      css: [tourStyles.euiTour, css, panelProps === null || panelProps === void 0 ? void 0 : panelProps.css]
    }),
    offset: hasBeacon ? 10 : 0,
    "aria-labelledby": titleId,
    arrowChildren: hasBeacon && (0, _react2.jsx)(_beacon.EuiBeacon, {
      css: beaconCss,
      className: "euiTour__beacon"
    }),
    onPositionChange: onPositionChange
  }, rest), (0, _react2.jsx)("div", {
    style: widthStyles
  }, (0, _react2.jsx)(_tour_header.EuiTourHeader, {
    id: titleId,
    title: title,
    subtitle: subtitle
  }), (0, _react2.jsx)("div", {
    className: "euiTour__content"
  }, content), (0, _react2.jsx)(_tour_footer.EuiTourFooter, {
    footerAction: footerAction,
    step: step,
    stepsTotal: stepsTotal,
    onFinish: onFinish
  }))) : null;
};
EuiTourStep.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Element to which the tour step popover attaches when open
       */
  children: _propTypes.default.element,
  anchor: _propTypes.default.any,
  /**
       * Contents of the tour step popover
       */
  content: _propTypes.default.node.isRequired,
  /**
       * Step will display if set to `true`
       */
  isStepOpen: _propTypes.default.bool,
  /**
       * Change the default min width of the popover panel
       */
  minWidth: _propTypes.default.any,
  /**
       * Change the default max width of the popover panel
       */
  maxWidth: _propTypes.default.any,
  /**
       * Function to call for 'Skip tour' and 'End tour' actions
       */
  onFinish: _propTypes.default.func.isRequired,
  /**
       * The number of the step within the parent tour. 1-based indexing.
       */
  step: _propTypes.default.number.isRequired,
  /**
       * The total number of steps in the tour
       */
  stepsTotal: _propTypes.default.number.isRequired,
  /**
       * Smaller title text that appears atop each step in the tour. The subtitle gets wrapped in the appropriate heading level.
       */
  subtitle: _propTypes.default.node,
  /**
       * Larger title text specific to this step. The title gets wrapped in the appropriate heading level.
       */
  title: _propTypes.default.node.isRequired,
  /**
       * Extra visual indication of step location
       */
  decoration: _propTypes.default.oneOf(["none", "beacon"]),
  /**
       * Accepts any `ReactNode` to replace the 'Skip tour' link in the footer.
       * Ideally, pass one button or an array of up to 2 buttons.
       */
  footerAction: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired])
};