"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTreeViewClass = exports.EuiTreeView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _accessibility = require("../accessibility");
var _tree_view_item = require("./tree_view_item");
var _tree_view = require("./tree_view.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "items", "display", "expandByDefault", "showExpansionArrows", "theme"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiTreeViewContext = /*#__PURE__*/(0, _react.createContext)('');
function getTreeId(propId) {
  var contextId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var idGenerator = arguments.length > 2 ? arguments[2] : undefined;
  return propId !== null && propId !== void 0 ? propId : contextId === '' ? idGenerator() : contextId;
}
var EuiTreeViewClass = exports.EuiTreeViewClass = /*#__PURE__*/function (_Component) {
  function EuiTreeViewClass(props,
  // Without the optional ? typing, TS will throw errors on JSX component errors
  // @see https://github.com/facebook/react/issues/13944#issuecomment-1183693239
  context) {
    var _this;
    (0, _classCallCheck2.default)(this, EuiTreeViewClass);
    // TODO: context in constructor has been deprecated.
    // We should likely convert this to a function component
    _this = _callSuper(this, EuiTreeViewClass, [props, context]);
    (0, _defineProperty2.default)(_this, "treeIdGenerator", (0, _services.htmlIdGenerator)('euiTreeView'));
    (0, _defineProperty2.default)(_this, "isNested", void 0);
    (0, _defineProperty2.default)(_this, "buttonRef", []);
    (0, _defineProperty2.default)(_this, "setButtonRef", function (ref, index) {
      _this.buttonRef[index] = ref;
    });
    (0, _defineProperty2.default)(_this, "handleNodeClick", function (node) {
      var ignoreCallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var index = _this.state.openItems.indexOf(node.id);
      _this.setState({
        expandChildNodes: false
      });
      node.isExpanded = !node.isExpanded;
      if (!ignoreCallback && node.callback !== undefined) {
        node.callback();
      }
      if (_this.isNodeOpen(node)) {
        // if the node is part of openItems[] then remove it
        _this.setState({
          openItems: _this.state.openItems.filter(function (_, i) {
            return i !== index;
          })
        });
      } else {
        // if the node isn't part of openItems[] then add it
        _this.setState(function (prevState) {
          return {
            openItems: [].concat((0, _toConsumableArray2.default)(prevState.openItems), [node.id]),
            activeItem: node.id
          };
        });
      }
    });
    // check if the node is included in openItems[]
    (0, _defineProperty2.default)(_this, "isNodeOpen", function (node) {
      return _this.state.openItems.includes(node.id);
    });
    // Enable keyboard navigation
    (0, _defineProperty2.default)(_this, "onKeyDown", function (event, node) {
      switch (event.key) {
        case _services.keys.ARROW_DOWN:
          {
            var nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"euiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var currentIndex = nodeButtons.indexOf(event.currentTarget);
            if (currentIndex > -1) {
              var nextButton = nodeButtons[currentIndex + 1];
              if (nextButton) {
                event.preventDefault();
                event.stopPropagation();
                nextButton.focus();
              }
            }
            break;
          }
        case _services.keys.ARROW_UP:
          {
            var _nodeButtons = Array.from(document.querySelectorAll("[data-test-subj=\"euiTreeViewButton-".concat(_this.state.treeID, "\"]")));
            var _currentIndex = _nodeButtons.indexOf(event.currentTarget);
            if (_currentIndex > -1) {
              var prevButton = _nodeButtons[_currentIndex + -1];
              if (prevButton) {
                event.preventDefault();
                event.stopPropagation();
                prevButton.focus();
              }
            }
            break;
          }
        case _services.keys.ARROW_RIGHT:
          {
            if (!_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
            break;
          }
        case _services.keys.ARROW_LEFT:
          {
            if (_this.isNodeOpen(node)) {
              event.preventDefault();
              event.stopPropagation();
              _this.handleNodeClick(node, true);
            }
          }
        default:
          break;
      }
    });
    (0, _defineProperty2.default)(_this, "onChildrenKeydown", function (event, index) {
      if (event.key === _services.keys.ARROW_LEFT) {
        event.preventDefault();
        event.stopPropagation();
        _this.buttonRef[index].focus();
      }
    });
    _this.isNested = !!_this.context;
    _this.state = {
      openItems: _this.props.expandByDefault ? _this.props.items.map(function (_ref) {
        var id = _ref.id,
          children = _ref.children;
        return children ? id : null;
      }).filter(function (x) {
        return x != null;
      }) : _this.props.items.map(function (_ref2) {
        var id = _ref2.id,
          children = _ref2.children,
          isExpanded = _ref2.isExpanded;
        return children && isExpanded ? id : null;
      }).filter(function (x) {
        return x != null;
      }),
      activeItem: '',
      treeID: getTreeId(_this.props.id, context, _this.treeIdGenerator),
      expandChildNodes: _this.props.expandByDefault || false
    };
    return _this;
  }
  (0, _inherits2.default)(EuiTreeViewClass, _Component);
  return (0, _createClass2.default)(EuiTreeViewClass, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.id !== prevProps.id) {
        this.setState({
          treeID: getTreeId(this.props.id, this.context, this.treeIdGenerator)
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        items = _this$props.items,
        _this$props$display = _this$props.display,
        display = _this$props$display === void 0 ? 'default' : _this$props$display,
        expandByDefault = _this$props.expandByDefault,
        showExpansionArrows = _this$props.showExpansionArrows,
        theme = _this$props.theme,
        rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var styles = (0, _tree_view.euiTreeViewStyles)(theme);
      var cssStyles = [styles.euiTreeView, styles[display]];

      // Computed classNames
      var classes = (0, _classnames.default)('euiTreeView', className);
      var instructionsId = "".concat(this.state.treeID, "--instruction");
      return (0, _react2.jsx)(EuiTreeViewContext.Provider, {
        value: this.state.treeID
      }, !this.isNested && (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTreeView.listNavigationInstructions",
        default: "You can quickly navigate this list using arrow keys."
      }, function (listNavigationInstructions) {
        return (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
          id: instructionsId
        }, listNavigationInstructions));
      }), (0, _react2.jsx)("ul", (0, _extends2.default)({
        css: cssStyles,
        className: classes,
        id: !this.isNested ? this.state.treeID : undefined,
        "aria-describedby": !this.isNested ? instructionsId : undefined,
        role: "list" // VoiceOver doesn't parse lists with `list-style: none` as the correct role - @see https://www.scottohara.me/blog/2019/01/12/lists-and-safari.html
      }, rest), items.map(function (node, index) {
        var buttonId = node.id;
        var wrappingId = _this2.treeIdGenerator(buttonId);
        var isNodeExpanded = node.children ? _this2.isNodeOpen(node) : undefined; // Determines the `aria-expanded` attribute

        var icon = node.icon;
        if (node.iconWhenExpanded && isNodeExpanded) {
          icon = node.iconWhenExpanded;
        } else if (!icon && node.useEmptyIcon) {
          icon = (0, _react2.jsx)(_react.default.Fragment, null); // Renders a placeholder
        }
        return (0, _react2.jsx)(_tree_view_item.EuiTreeViewItem, {
          key: buttonId + index,
          id: buttonId,
          className: node.className,
          buttonRef: function buttonRef(ref) {
            return _this2.setButtonRef(ref, index);
          },
          "aria-controls": node.children ? wrappingId : undefined,
          label: node.label,
          icon: icon,
          hasArrow: showExpansionArrows,
          isExpanded: isNodeExpanded,
          isActive: _this2.state.activeItem === node.id,
          display: display,
          "data-test-subj": "euiTreeViewButton-".concat(_this2.state.treeID),
          onKeyDown: function onKeyDown(event) {
            return _this2.onKeyDown(event, node);
          },
          onClick: function onClick() {
            return _this2.handleNodeClick(node);
          }
        }, node.children && (0, _react2.jsx)("div", {
          id: wrappingId,
          onKeyDown: function onKeyDown(event) {
            return _this2.onChildrenKeydown(event, index);
          }
        }, isNodeExpanded && (0, _react2.jsx)(EuiTreeView, {
          items: node.children,
          display: display,
          showExpansionArrows: showExpansionArrows,
          expandByDefault: _this2.state.expandChildNodes
        })));
      })));
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiTreeViewClass, "contextType", EuiTreeViewContext);
EuiTreeViewClass.propTypes = {
  className: _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * An array of EuiTreeViewNodes
       */
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    /** An array of EuiTreeViewNodes to render as children
       */
    children: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
    /** The readable label for the item
       */
    label: _propTypes.default.node.isRequired,
    /** A unique ID
       */
    id: _propTypes.default.string.isRequired,
    /** An icon to use on the left of the label
       */
    icon: _propTypes.default.element,
    /** Display a different icon when the item is expanded.
      For instance, an open folder or a down arrow
      */
    iconWhenExpanded: _propTypes.default.element,
    /** Use an empty icon to keep items without an icon
      lined up with their siblings
      */
    useEmptyIcon: _propTypes.default.bool,
    /** Whether or not the item is expanded.
       */
    isExpanded: _propTypes.default.bool,
    /** Optional class to throw on the node
       */
    className: _propTypes.default.string,
    /** Function to call when the item is clicked.
       The open state of the item will always be toggled.
       */
    callback: _propTypes.default.func
  }).isRequired).isRequired,
  /**
       * Optionally use a variation with smaller text and icon sizes
       * @default default
       */
  display: _propTypes.default.oneOf(["default", "compressed"]),
  /**
       * Set all items to open on initial load
       */
  expandByDefault: _propTypes.default.bool,
  /**
       * Display expansion arrows next to all items
       * that contain children
       */
  showExpansionArrows: _propTypes.default.bool,
  "aria-label": _propTypes.default.string,
  "aria-labelledby": _propTypes.default.string
};
var EuiTreeView = exports.EuiTreeView = Object.assign((0, _services.withEuiTheme)(EuiTreeViewClass), {
  Item: _tree_view_item.EuiTreeViewItem
});