"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.htmlIdGenerator = htmlIdGenerator;
exports.useGeneratedHtmlId = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function htmlIdGenerator() {
  var idPrefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var staticUuid = 'generated-id';
  return function () {
    var idSuffix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    var prefix = "".concat(idPrefix).concat(idPrefix !== '' ? '_' : '');
    var suffix = idSuffix ? "_".concat(idSuffix) : '';
    return "".concat(prefix).concat(staticUuid).concat(suffix);
  };
}
var useGeneratedHtmlId = exports.useGeneratedHtmlId = function useGeneratedHtmlId() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    prefix = _ref.prefix,
    suffix = _ref.suffix,
    conditionalId = _ref.conditionalId;
  // Skip useMemo in test environments - it's not necessary since the uuid is static/mocked
  return conditionalId || htmlIdGenerator(prefix)(suffix);
};