"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentEuiBreakpoint = void 0;
var _react = require("react");
var _common = require("../../components/common");
var _breakpoint = require("../../themes/amsterdam/global_styling/variables/_breakpoint");
var _current_breakpoint = require("./current_breakpoint");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Jest tests *likely* will not have a wrapping EuiProvider. If they don't,
 * this test mock mimics CurrentEuiBreakpoint logic (w/o resize observers).
 */
var useCurrentEuiBreakpoint = exports.useCurrentEuiBreakpoint = function useCurrentEuiBreakpoint() {
  var context = (0, _react.useContext)(_current_breakpoint.CurrentEuiBreakpointContext);
  if (context !== undefined) return context; // Component has been wrapped, everything is fine.

  if (typeof window === 'undefined') return undefined; // SSR catch

  // Use the default Amsterdam breakpoints (which are already ordered by largest first)
  return (0, _common.keysOf)(_breakpoint.breakpoint).find(function (key) {
    return _breakpoint.breakpoint[key] <= window.innerWidth;
  });
};