"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloneElementWithCss = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * React.cloneElement does not work if the cloned element does not already have the
 * `css` prop - as a result, we need to use `jsx()` to manually clone the element
 * See https://github.com/emotion-js/emotion/issues/1404
 */
var cloneElementWithCss = exports.cloneElementWithCss = function cloneElementWithCss(element, props) {
  var cssOrder = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'after';
  var clonedElement = element.props.__EMOTION_TYPE_PLEASE_DO_NOT_USE__ || element.type; // EMOTION_TYPE handles non-React elements (native JSX/HTML nodes)

  var clonedProps = _objectSpread(_objectSpread(_objectSpread({}, element.key ? {
    key: element.key
  } : {}), {}, {
    ref: element.ref
  }, element.props), props);
  if (props.css || element.props.css) {
    clonedProps.css = cssOrder === 'before' ? [props.css, element.props.css] : [element.props.css, props.css];
  }
  return (0, _react.jsx)(clonedElement, clonedProps);
};