"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.never = exports.isUndefined = exports.isNull = exports.isNil = exports.isMoment = exports.isDateLike = exports.isDate = exports.always = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var always = exports.always = function always(_value) {
  return true;
};
var never = exports.never = function never(_value) {
  return false;
};
var isUndefined = exports.isUndefined = function isUndefined(value) {
  return value === undefined;
};
var isNull = exports.isNull = function isNull(value) {
  return value === null;
};
var isNil = exports.isNil = function isNil(value) {
  return isUndefined(value) || isNull(value);
};
var isMoment = exports.isMoment = function isMoment(value) {
  return _moment.default.isMoment(value);
};
var isDate = exports.isDate = function isDate(value) {
  return _moment.default.isDate(value);
};
var isDateLike = exports.isDateLike = function isDateLike(value) {
  return isMoment(value) || isDate(value);
};