"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withEuiTheme = exports.useEuiThemeCSSVariables = exports.useEuiTheme = exports.RenderWithEuiTheme = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _context = require("./context");
var _warning = require("./warning");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var providerMessage = "`EuiProvider` is missing which can result in negative effects.\nWrap your component in `EuiProvider`: https://ela.st/euiprovider.";

/**
 * Hook for function components
 */

var useEuiTheme = exports.useEuiTheme = function useEuiTheme() {
  var theme = (0, _react.useContext)(_context.EuiThemeContext);
  var colorMode = (0, _react.useContext)(_context.EuiColorModeContext);
  var modifications = (0, _react.useContext)(_context.EuiModificationsContext);
  var isFallback = theme === _context.defaultComputedTheme;
  if (isFallback) {
    (0, _warning.emitEuiProviderWarning)(providerMessage);
  }
  var assembledTheme = (0, _react.useMemo)(function () {
    return {
      euiTheme: theme,
      colorMode: colorMode,
      modifications: modifications
    };
  }, [theme, colorMode, modifications]);
  return assembledTheme;
};

/**
 * HOC for class components
 */

// Provide the component props interface as the generic to allow the docs props table to populate.
// e.g., `const EuiComponent = withEuiTheme<EuiComponentProps>(_EuiComponent)`
var withEuiTheme = exports.withEuiTheme = function withEuiTheme(Component) {
  var componentName = Component.displayName || Component.name || 'ComponentWithTheme';
  var Render = function Render(props, ref) {
    var theme = useEuiTheme();
    return (0, _react2.jsx)(Component, (0, _extends2.default)({
      theme: theme,
      ref: ref
    }, props));
  };
  var WithEuiTheme = /*#__PURE__*/(0, _react.forwardRef)(Render);
  WithEuiTheme.displayName = componentName;
  return WithEuiTheme;
};

/**
 * Render prop alternative for complex class components
 * Most useful for scenarios where a HOC may interfere with typing
 */
var RenderWithEuiTheme = exports.RenderWithEuiTheme = function RenderWithEuiTheme(_ref) {
  var children = _ref.children;
  var theme = useEuiTheme();
  return children(theme);
};

/**
 * Minor syntactical sugar hook for theme CSS variables.
 * Primarily meant for internal EUI usage.
 */
var useEuiThemeCSSVariables = exports.useEuiThemeCSSVariables = function useEuiThemeCSSVariables() {
  var _useContext = (0, _react.useContext)(_context.EuiNestedThemeContext),
    setGlobalCSSVariables = _useContext.setGlobalCSSVariables,
    globalCSSVariables = _useContext.globalCSSVariables,
    setNearestThemeCSSVariables = _useContext.setNearestThemeCSSVariables,
    themeCSSVariables = _useContext.themeCSSVariables;
  return {
    setGlobalCSSVariables: setGlobalCSSVariables,
    globalCSSVariables: globalCSSVariables,
    setNearestThemeCSSVariables: setNearestThemeCSSVariables,
    themeCSSVariables: themeCSSVariables
  };
};