"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiThemeProvider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _taggedTemplateLiteral2 = _interopRequireDefault(require("@babel/runtime/helpers/taggedTemplateLiteral"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _isEqual = _interopRequireDefault(require("lodash/isEqual"));
var _emotion = require("../emotion");
var _css2 = require("../emotion/css");
var _current_breakpoint = require("../breakpoint/current_breakpoint");
var _context = require("./context");
var _emotion2 = require("./emotion");
var _style_memoization = require("./style_memoization");
var _utils = require("./utils");
var _excluded = ["cloneElement", "className"];
var _templateObject;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiThemeProvider = exports.EuiThemeProvider = function EuiThemeProvider(_ref) {
  var _system = _ref.theme,
    _colorMode = _ref.colorMode,
    _modifications = _ref.modify,
    children = _ref.children,
    wrapperProps = _ref.wrapperProps;
  var _useContext = (0, _react2.useContext)(_context.EuiNestedThemeContext),
    isGlobalTheme = _useContext.isGlobalTheme,
    bodyColor = _useContext.bodyColor,
    globalCSSVariables = _useContext.globalCSSVariables,
    setGlobalCSSVariables = _useContext.setGlobalCSSVariables;
  var parentSystem = (0, _react2.useContext)(_context.EuiSystemContext);
  var parentModifications = (0, _react2.useContext)(_context.EuiModificationsContext);
  var parentColorMode = (0, _react2.useContext)(_context.EuiColorModeContext);
  var parentTheme = (0, _react2.useContext)(_context.EuiThemeContext);
  var _useState = (0, _react2.useState)(_system || parentSystem),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    system = _useState2[0],
    setSystem = _useState2[1];
  var prevSystemKey = (0, _react2.useRef)(system.key);

  // To reduce the number of window resize listeners, only render a
  // CurrentEuiBreakpointProvider for the top level parent theme, or for
  // nested themes only if modified breakpoint overrides are passed
  var EuiConditionalBreakpointProvider = (0, _react2.useMemo)(function () {
    return isGlobalTheme || _modifications !== null && _modifications !== void 0 && _modifications.breakpoint ? _current_breakpoint.CurrentEuiBreakpointProvider : _react2.Fragment;
  }, [isGlobalTheme, _modifications]);
  var _useState3 = (0, _react2.useState)((0, _utils.mergeDeep)(parentModifications, _modifications)),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    modifications = _useState4[0],
    setModifications = _useState4[1];
  var prevModifications = (0, _react2.useRef)(modifications);
  var _useState5 = (0, _react2.useState)((0, _utils.getColorMode)(_colorMode, parentColorMode)),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    colorMode = _useState6[0],
    setColorMode = _useState6[1];
  var prevColorMode = (0, _react2.useRef)(colorMode);
  var isParentTheme = (0, _react2.useRef)(prevSystemKey.current === parentSystem.key && colorMode === parentColorMode && (0, _isEqual.default)(parentModifications, modifications));
  var _useState7 = (0, _react2.useState)(isParentTheme.current && Object.keys(parentTheme).length ? _objectSpread({}, parentTheme) // Intentionally create a new object to break referential equality
    : (0, _utils.getComputed)(system, (0, _utils.buildTheme)(modifications, "_".concat(system.key)), colorMode)),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    theme = _useState8[0],
    setTheme = _useState8[1];
  (0, _react2.useEffect)(function () {
    var newSystem = _system || parentSystem;
    if (prevSystemKey.current !== newSystem.key) {
      setSystem(newSystem);
      prevSystemKey.current = newSystem.key;
      isParentTheme.current = false;
    }
  }, [_system, parentSystem]);
  (0, _react2.useEffect)(function () {
    var newModifications = (0, _utils.mergeDeep)(parentModifications, _modifications);
    if (!(0, _isEqual.default)(prevModifications.current, newModifications)) {
      setModifications(newModifications);
      prevModifications.current = newModifications;
      isParentTheme.current = false;
    }
  }, [_modifications, parentModifications]);
  (0, _react2.useEffect)(function () {
    var newColorMode = (0, _utils.getColorMode)(_colorMode, parentColorMode);
    if (!(0, _isEqual.default)(newColorMode, prevColorMode.current)) {
      setColorMode(newColorMode);
      prevColorMode.current = newColorMode;
      isParentTheme.current = false;
    }
  }, [_colorMode, parentColorMode]);
  (0, _react2.useEffect)(function () {
    if (!isParentTheme.current) {
      setTheme((0, _utils.getComputed)(system, (0, _utils.buildTheme)(modifications, "_".concat(system.key)), colorMode));
    }
  }, [colorMode, system, modifications]);
  var _useState9 = (0, _react2.useState)(),
    _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
    themeCSSVariables = _useState10[0],
    _setThemeCSSVariables = _useState10[1];
  var setThemeCSSVariables = (0, _react2.useCallback)(function (variables) {
    return _setThemeCSSVariables(function (previous) {
      return _objectSpread(_objectSpread({}, previous), variables);
    });
  }, []);
  var nestedThemeContext = (0, _react2.useMemo)(function () {
    return {
      isGlobalTheme: false,
      // The theme that determines the global body styles
      bodyColor: isGlobalTheme ? theme.colors.text : bodyColor,
      hasDifferentColorFromGlobalTheme: isGlobalTheme ? false : bodyColor !== theme.colors.text,
      colorClassName: (0, _css2.css)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n        label: euiColorMode-", ";\n        color: ", ";\n      "])), _colorMode || colorMode, theme.colors.text),
      setGlobalCSSVariables: isGlobalTheme ? setThemeCSSVariables : setGlobalCSSVariables,
      globalCSSVariables: isGlobalTheme ? themeCSSVariables : globalCSSVariables,
      setNearestThemeCSSVariables: setThemeCSSVariables,
      themeCSSVariables: themeCSSVariables
    };
  }, [theme, isGlobalTheme, bodyColor, _colorMode, colorMode, setGlobalCSSVariables, globalCSSVariables, setThemeCSSVariables, themeCSSVariables]);
  var renderedChildren = (0, _react2.useMemo)(function () {
    if (isGlobalTheme) {
      return children; // No wrapper
    }
    var _ref2 = wrapperProps || {},
      cloneElement = _ref2.cloneElement,
      className = _ref2.className,
      rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
    var props = _objectSpread(_objectSpread({}, rest), {}, {
      className: (0, _css2.cx)(className, nestedThemeContext.colorClassName)
    });
    // Condition avoids rendering an empty Emotion selector if no
    // theme-specific CSS variables have been set by child components
    if (themeCSSVariables) {
      props.css = _objectSpread({
        label: 'euiCSSVariables'
      }, themeCSSVariables);
    }
    if (cloneElement) {
      return (0, _emotion.cloneElementWithCss)(children, _objectSpread(_objectSpread({}, props), {}, {
        className: (0, _css2.cx)(children.props.className, props.className)
      }));
    } else {
      return (0, _react.jsx)("span", (0, _extends2.default)({}, props, {
        className: (0, _css2.cx)('euiThemeProvider', props.className)
      }), children);
    }
  }, [isGlobalTheme, themeCSSVariables, nestedThemeContext, wrapperProps, children]);
  return (0, _react.jsx)(_react2.default.Fragment, null, isGlobalTheme && themeCSSVariables && (0, _react.jsx)(_react.Global, {
    styles: /*#__PURE__*/(0, _react.css)({
      ':root': themeCSSVariables
    }, ";label:EuiThemeProvider;")
  }), (0, _react.jsx)(_context.EuiColorModeContext.Provider, {
    value: colorMode
  }, (0, _react.jsx)(_context.EuiSystemContext.Provider, {
    value: system
  }, (0, _react.jsx)(_context.EuiModificationsContext.Provider, {
    value: modifications
  }, (0, _react.jsx)(_context.EuiThemeContext.Provider, {
    value: theme
  }, (0, _react.jsx)(_context.EuiNestedThemeContext.Provider, {
    value: nestedThemeContext
  }, (0, _react.jsx)(_style_memoization.EuiThemeMemoizedStylesProvider, null, (0, _react.jsx)(_emotion2.EuiEmotionThemeProvider, null, (0, _react.jsx)(EuiConditionalBreakpointProvider, null, renderedChildren)))))))));
};