"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withEuiStylesMemoizer = exports.useEuiMemoizedStyles = exports.RenderWithEuiStylesMemoizer = exports.EuiThemeMemoizedStylesProvider = exports.EuiThemeMemoizedStylesContext = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../hooks");
var _hooks2 = require("./hooks");
var _warning = require("./warning");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Typically an object of serialized css`` styles, but can have any amount of nesting, so it's not worth it to try and strictly type this

var EuiThemeMemoizedStylesContext = exports.EuiThemeMemoizedStylesContext = /*#__PURE__*/(0, _react.createContext)(new WeakMap());
var EuiThemeMemoizedStylesProvider = exports.EuiThemeMemoizedStylesProvider = function EuiThemeMemoizedStylesProvider(_ref) {
  var children = _ref.children;
  // Note: we *should not* use `useMemo` instead of `useState` here, as useMemo is not guaranteed
  // and its cache can get thrown away by React (https://react.dev/reference/react/useMemo#caveats)
  var _useState = (0, _react.useState)(new WeakMap()),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    componentStyles = _useState2[0],
    rerenderStyles = _useState2[1];

  // On theme update, wipe the map, which causes the below hook to recompute all styles
  var _useEuiTheme = (0, _hooks2.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme;
  (0, _hooks.useUpdateEffect)(function () {
    rerenderStyles(new WeakMap());
  }, [euiTheme]);
  return (0, _react2.jsx)(EuiThemeMemoizedStylesContext.Provider, {
    value: componentStyles
  }, children);
};

/**
 * Internal util primarily responsible for getting the memoized styles (if they exist)
 * and if not, generating and setting the styles. DRYed out to facilitate usage
 * between both hook/function components and HOC/class components
 */
var getMemoizedStyles = function getMemoizedStyles(stylesGenerator, stylesMap, euiThemeContext) {
  if (!stylesGenerator.name) {
    (0, _warning.emitEuiProviderWarning)('Styles are memoized per function. Your style functions must be statically defined in order to not create a new map entry every rerender.');
  }
  var existingStyles = stylesMap.get(stylesGenerator);
  if (existingStyles) {
    return existingStyles;
  } else {
    var generatedStyles = stylesGenerator(euiThemeContext);
    stylesMap.set(stylesGenerator, generatedStyles);
    return generatedStyles;
  }
};

/**
 * Hook that memoizes the returned values of components style fns/generators
 * per-theme
 */
var useEuiMemoizedStyles = exports.useEuiMemoizedStyles = function useEuiMemoizedStyles(stylesGenerator) {
  var memoizedStyles = (0, _react.useContext)(EuiThemeMemoizedStylesContext);
  var euiThemeContext = (0, _hooks2.useEuiTheme)();
  var memoizedComponentStyles = (0, _react.useMemo)(function () {
    return getMemoizedStyles(stylesGenerator, memoizedStyles, euiThemeContext);
  }, [stylesGenerator, memoizedStyles, euiThemeContext]);
  return memoizedComponentStyles;
};

/**
 * HOC for class components
 * Syntax is mostly copied from withEuiTheme HOC
 */

var withEuiStylesMemoizer = exports.withEuiStylesMemoizer = function withEuiStylesMemoizer(Component) {
  var componentName = Component.displayName || Component.name || 'ComponentWithStylesMemoizer';
  var Render = function Render(props, ref) {
    var memoizedStyles = (0, _react.useContext)(EuiThemeMemoizedStylesContext);
    var euiThemeContext = (0, _hooks2.useEuiTheme)();
    var stylesMemoizer = (0, _react.useCallback)(function (stylesGenerator) {
      return getMemoizedStyles(stylesGenerator, memoizedStyles, euiThemeContext);
    }, [memoizedStyles, euiThemeContext]);
    return (0, _react2.jsx)(Component, (0, _extends2.default)({
      stylesMemoizer: stylesMemoizer,
      ref: ref
    }, props));
  };
  var WithEuiStylesMemoizer = /*#__PURE__*/(0, _react.forwardRef)(Render);
  WithEuiStylesMemoizer.displayName = componentName;
  return WithEuiStylesMemoizer;
};

/**
 * Render prop alternative for complex class components
 * Most useful for scenarios where a HOC may interfere with typing
 */
var RenderWithEuiStylesMemoizer = exports.RenderWithEuiStylesMemoizer = function RenderWithEuiStylesMemoizer(_ref2) {
  var children = _ref2.children;
  var memoizedStyles = (0, _react.useContext)(EuiThemeMemoizedStylesContext);
  var euiThemeContext = (0, _hooks2.useEuiTheme)();
  var stylesMemoizer = (0, _react.useCallback)(function (stylesGenerator) {
    return getMemoizedStyles(stylesGenerator, memoizedStyles, euiThemeContext);
  }, [memoizedStyles, euiThemeContext]);
  return children(stylesMemoizer);
};