"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.within = exports.screen = exports.render = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("@testing-library/react");
var _provider = require("../../components/provider");
var dataTestSubjQueries = _interopRequireWildcard(require("./data_test_subj_queries"));
var _excluded = ["queries"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/**
 * Custom render() fn with EuiProvider and query helpers
 *
 * @see https://testing-library.com/docs/react-testing-library/setup#custom-render
 * @see https://testing-library.com/docs/react-testing-library/setup#add-custom-queries
 */

var customRender = exports.render = function customRender(ui) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var renderQueries = _ref.queries,
    options = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return (0, _react.render)(ui, _objectSpread({
    queries: _objectSpread(_objectSpread(_objectSpread({}, _react.queries), dataTestSubjQueries), renderQueries || {}),
    wrapper: _provider.EuiProvider
  }, options));
};
/**
 * Custom screen util with EUI query helpers
 *
 * @see https://testing-library.com/docs/queries/about/#screen
 * @see https://github.com/testing-library/dom-testing-library/issues/516
 */
var customScreen = exports.screen = _objectSpread(_objectSpread({}, _react.screen), (0, _react.within)(document.body, dataTestSubjQueries));
/**
 * Custom within util with EUI query helpers
 *
 * @see https://testing-library.com/docs/dom-testing-library/api-within/
 */
var customWithin = exports.within = function customWithin(element) {
  return (0, _react.within)(element, _objectSpread(_objectSpread({}, _react.queries), dataTestSubjQueries));
};