"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiThemeAmsterdam = exports.EuiThemeAmsterdam = exports.AMSTERDAM_NAME_KEY = void 0;
var _utils = require("../../services/theme/utils");
var _colors = require("./global_styling/variables/_colors");
var _animation = require("./global_styling/variables/_animation");
var _breakpoint = require("./global_styling/variables/_breakpoint");
var _size = require("./global_styling/variables/_size");
var _borders = require("./global_styling/variables/_borders");
var _levels = require("./global_styling/variables/_levels");
var _typography = require("./global_styling/variables/_typography");
var _states = require("./global_styling/variables/_states");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var AMSTERDAM_NAME_KEY = exports.AMSTERDAM_NAME_KEY = 'EUI_THEME_AMSTERDAM';
var euiThemeAmsterdam = exports.euiThemeAmsterdam = {
  colors: _colors.colors,
  base: _size.base,
  size: _size.size,
  border: _borders.border,
  font: _typography.font,
  animation: _animation.animation,
  breakpoint: _breakpoint.breakpoint,
  levels: _levels.levels,
  focus: _states.focus
};
var EuiThemeAmsterdam = exports.EuiThemeAmsterdam = (0, _utils.buildTheme)(euiThemeAmsterdam, AMSTERDAM_NAME_KEY);