"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patchConsoleError", {
    enumerable: true,
    get: function() {
        return patchConsoleError;
    }
});
const _isnextroutererror = require("../is-next-router-error");
const _useerrorhandler = require("../react-dev-overlay/internal/helpers/use-error-handler");
const originConsoleError = window.console.error;
function patchConsoleError() {
    // Ensure it's only patched once
    if (typeof window === 'undefined') {
        return;
    }
    window.console.error = function() {
        for(var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++){
            args[_key] = arguments[_key];
        }
        // See https://github.com/facebook/react/blob/d50323eb845c5fde0d720cae888bf35dedd05506/packages/react-reconciler/src/ReactFiberErrorLogger.js#L78
        const error = process.env.NODE_ENV !== 'production' ? args[1] : args[0];
        if (!(0, _isnextroutererror.isNextRouterError)(error)) {
            if (process.env.NODE_ENV !== 'production') {
                (0, _useerrorhandler.handleClientError)(error, args);
            }
            originConsoleError.apply(window.console, args);
        }
    };
}

if ((typeof exports.default === 'function' || (typeof exports.default === 'object' && exports.default !== null)) && typeof exports.default.__esModule === 'undefined') {
  Object.defineProperty(exports.default, '__esModule', { value: true });
  Object.assign(exports.default, exports);
  module.exports = exports.default;
}

//# sourceMappingURL=intercept-console-error.js.map