import type { StackFrame } from 'next/dist/compiled/stacktrace-parser';
import { getSourceMapFromFile } from '../internal/helpers/get-source-map-from-file';
import { type OriginalStackFrameResponse } from './shared';
export { getServerError } from '../internal/helpers/node-stack-frames';
export { parseStack } from '../internal/helpers/parse-stack';
export { getSourceMapFromFile };
import type { IncomingMessage, ServerResponse } from 'http';
import type webpack from 'webpack';
import type { RawSourceMap } from 'next/dist/compiled/source-map08';
type Source = {
    type: 'file';
    sourceMap: RawSourceMap;
    modulePath: string;
} | {
    type: 'bundle';
    sourceMap: RawSourceMap;
    compilation: webpack.Compilation;
    moduleId: string;
    modulePath: string;
};
export declare function createOriginalStackFrame({ source, rootDirectory, frame, errorMessage, }: {
    source: Source;
    rootDirectory: string;
    frame: StackFrame;
    errorMessage?: string;
}): Promise<OriginalStackFrameResponse | undefined>;
export declare function getSourceMapFromCompilation(id: string, compilation: webpack.Compilation): Promise<RawSourceMap | undefined>;
export declare function getSource(filename: string, options: {
    distDirectory: string;
    getCompilations: () => webpack.Compilation[];
}): Promise<Source | undefined>;
export declare function getOverlayMiddleware(options: {
    distDirectory: string;
    rootDirectory: string;
    clientStats: () => webpack.Stats | null;
    serverStats: () => webpack.Stats | null;
    edgeServerStats: () => webpack.Stats | null;
}): (req: IncomingMessage, res: ServerResponse, next: () => void) => Promise<void>;
export declare function getSourceMapMiddleware(options: {
    distDirectory: string;
    clientStats: () => webpack.Stats | null;
    serverStats: () => webpack.Stats | null;
    edgeServerStats: () => webpack.Stats | null;
}): (req: IncomingMessage, res: ServerResponse, next: () => void) => Promise<void>;
