"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "withWorkStore", {
    enumerable: true,
    get: function() {
        return withWorkStore;
    }
});
const _aftercontext = require("../after/after-context");
const _apppaths = require("../../shared/lib/router/utils/app-paths");
const withWorkStore = (storage, { page, fallbackRouteParams, renderOpts, requestEndedState, isPrefetchRequest }, callback)=>{
    /**
   * Rules of Static & Dynamic HTML:
   *
   *    1.) We must generate static HTML unless the caller explicitly opts
   *        in to dynamic HTML support.
   *
   *    2.) If dynamic HTML support is requested, we must honor that request
   *        or throw an error. It is the sole responsibility of the caller to
   *        ensure they aren't e.g. requesting dynamic HTML for an AMP page.
   *
   *    3.) If the request is in draft mode, we must generate dynamic HTML.
   *
   *    4.) If the request is a server action, we must generate dynamic HTML.
   *
   * These rules help ensure that other existing features like request caching,
   * coalescing, and ISR continue working as intended.
   */ const isStaticGeneration = !renderOpts.supportsDynamicResponse && !renderOpts.isDraftMode && !renderOpts.isServerAction;
    const store = {
        isStaticGeneration,
        page,
        fallbackRouteParams,
        route: (0, _apppaths.normalizeAppPath)(page),
        incrementalCache: // we fallback to a global incremental cache for edge-runtime locally
        // so that it can access the fs cache without mocks
        renderOpts.incrementalCache || globalThis.__incrementalCache,
        cacheLifeProfiles: renderOpts.cacheLifeProfiles,
        isRevalidate: renderOpts.isRevalidate,
        isPrerendering: renderOpts.nextExport,
        fetchCache: renderOpts.fetchCache,
        isOnDemandRevalidate: renderOpts.isOnDemandRevalidate,
        isDraftMode: renderOpts.isDraftMode,
        requestEndedState,
        isPrefetchRequest,
        buildId: renderOpts.buildId,
        reactLoadableManifest: (renderOpts == null ? void 0 : renderOpts.reactLoadableManifest) || {},
        assetPrefix: (renderOpts == null ? void 0 : renderOpts.assetPrefix) || '',
        afterContext: createAfterContext(renderOpts)
    };
    // TODO: remove this when we resolve accessing the store outside the execution context
    renderOpts.store = store;
    return storage.run(store, callback, store);
};
function createAfterContext(renderOpts) {
    var _renderOpts_experimental;
    const isAfterEnabled = (renderOpts == null ? void 0 : (_renderOpts_experimental = renderOpts.experimental) == null ? void 0 : _renderOpts_experimental.after) ?? false;
    if (!isAfterEnabled) {
        return undefined;
    }
    const { waitUntil, onClose, onAfterTaskError } = renderOpts;
    return new _aftercontext.AfterContext({
        waitUntil,
        onClose,
        onTaskError: onAfterTaskError
    });
}

//# sourceMappingURL=with-work-store.js.map