"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PrefetchCacheScopes", {
    enumerable: true,
    get: function() {
        return PrefetchCacheScopes;
    }
});
class PrefetchCacheScopes {
    evict() {
        for (const [key, value] of this.cacheScopes){
            if (value.timestamp < Date.now() - 30000) {
                this.cacheScopes.delete(key);
            }
        }
    }
    // TODO: should this key include query params if so we need to
    // filter _rsc query
    get(url) {
        var _this_cacheScopes_get;
        setImmediate(()=>this.evict());
        return (_this_cacheScopes_get = this.cacheScopes.get(url)) == null ? void 0 : _this_cacheScopes_get.cache;
    }
    set(url, cache) {
        setImmediate(()=>this.evict());
        return this.cacheScopes.set(url, {
            cache,
            timestamp: Date.now()
        });
    }
    del(url) {
        this.cacheScopes.delete(url);
    }
    constructor(){
        this.cacheScopes = new Map();
    }
}

//# sourceMappingURL=prefetch-cache-scopes.js.map