"use client"

import { EuiProvider } from "@elastic/eui";
import { ToastProvider } from "@/app/components/ToastProvider";
import { LoaderProvider } from "@/context/LoaderContext";

export function Providers({ children }: { children: React.ReactNode }) {
  return (
    <LoaderProvider>
      <EuiProvider colorMode="light">
        <ToastProvider>{children}</ToastProvider>
      </EuiProvider>
    </LoaderProvider>
  );
}
