import React from 'react';
import { motion } from 'framer-motion';
import { isSmallScreen } from '../../utils/helpers';

export const ModuleCard = ({ option, onClick }) => (
    <motion.div
        onClick={onClick}
        whileHover={{
            scale: 1.03,
            y: -4,
            transition: { duration: 0.2, ease: [0.4, 0, 0.2, 1] }
        }}
        whileTap={{ scale: 0.98 }}
        style={{
            background: option.cardColor,
            color: 'white',
            borderRadius: '16px',
            cursor: 'pointer',
            minHeight: isSmallScreen() ? '130px' : '150px',
            display: 'flex',
            flexDirection: 'column',
            alignItems: 'center',
            justifyContent: 'center',
            padding: isSmallScreen() ? '20px' : '24px',
            transition: 'all 0.3s cubic-bezier(0.4, 0, 0.2, 1)',
            boxShadow: '0 10px 30px -5px rgba(220, 38, 38, 0.25)',
            border: '1px solid rgba(255, 255, 255, 0.2)',
        }}
    >
        <div style={{
            fontSize: isSmallScreen() ? '28px' : '32px',
            marginBottom: '12px',
            filter: 'drop-shadow(0 2px 4px rgba(0,0,0,0.2))'
        }}>
            {option.icon}
        </div>
        <div style={{
            fontWeight: '600',
            fontSize: isSmallScreen() ? '15px' : '17px',
            textAlign: 'center',
            marginBottom: '4px'
        }}>
            {option.name}
        </div>
        <div style={{
            fontSize: '13px',
            color: 'rgba(255, 255, 255, 0.9)',
            textAlign: 'center',
            fontWeight: '400'
        }}>
            {option.description}
        </div>
    </motion.div>
);
