import React, { useRef } from 'react';
import {
    EuiSpacer,
    EuiFlexGroup,
    EuiLoadingSpinner,
    EuiFlexItem
} from '@elastic/eui';
import { motion } from 'framer-motion';
import { EuiText } from '../ui';

import getDict from '@/lib/dict';
const dict = getDict("de");

export const FileUploadComponent = ({ onFileSelect, accept, apiLoading }) => {
    const fileInputRef = useRef(null);

    const openFileDialog = () => fileInputRef.current?.click();

    const handleFileChange = (e) => {
        const file = e.target.files;
        if (file && onFileSelect) {
            onFileSelect(file);
        }
    };


    return (
        <div style={{ position: 'relative' }}>

            <input
                ref={fileInputRef}
                type="file"
                accept={accept}
                onChange={handleFileChange}
                style={{ display: 'none' }}
            />
            <motion.div
                onClick={openFileDialog}
                whileHover={{ scale: 1.02 }}
                whileTap={{ scale: 0.98 }}
                style={{
                    border: '2px dashed #d1d5db',
                    borderRadius: '12px',
                    padding: '40px 20px',
                    textAlign: 'center',
                    cursor: 'pointer',
                    transition: 'all 0.3s ease',
                    backgroundColor: 'rgba(255, 255, 255, 0.8)',
                }}
                onMouseEnter={(e) => {
                    e.currentTarget.style.borderColor = '#dc2626';
                    e.currentTarget.style.backgroundColor = 'rgba(220, 38, 38, 0.05)';
                }}
                onMouseLeave={(e) => {
                    e.currentTarget.style.borderColor = '#d1d5db';
                    e.currentTarget.style.backgroundColor = 'rgba(255, 255, 255, 0.8)';
                }}
            >
                <div style={{ fontSize: '48px', marginBottom: '16px' }}>📁</div>
                <EuiText size="m" style={{ fontWeight: '600', marginBottom: '8px' }}>
                    {dict.clickUpload}
                </EuiText>
                <EuiText size="s" color="subdued">
                    {dict.pdf}
                </EuiText>
                {apiLoading && <EuiText size="s" color="subdued">
                    <EuiLoadingSpinner size="m"/>
                </EuiText>}
            </motion.div>
        </div>
    );
};
