import React from 'react';
import { motion } from 'framer-motion';
import { EuiText } from '../ui';

export const ProjectTypeCard = ({ type, icon, title, description, selected, onClick }) => (
    <motion.div
        onClick={onClick}
        whileHover={{ scale: 1.02 }}
        whileTap={{ scale: 0.98 }}
        style={{
            padding: '16px 20px',
            borderRadius: '12px',
            border: selected ? '2px solid #dc2626' : '2px solid #e5e7eb',
            backgroundColor: selected ? 'rgba(220, 38, 38, 0.05)' : 'white',
            cursor: 'pointer',
            transition: 'all 0.2s ease',
            display: 'flex',
            alignItems: 'center',
            gap: '12px'
        }}
    >
        <div style={{ fontSize: '24px', filter: 'drop-shadow(0 2px 4px rgba(0,0,0,0.1))' }}>
            {icon}
        </div>
        <div style={{ flex: 1 }}>
            <EuiText style={{ fontWeight: '600', marginBottom: '4px' }}>
                {title}
            </EuiText>
            <EuiText size="s" color="subdued">
                {description}
            </EuiText>
        </div>
        {selected && (
            <div style={{ color: '#dc2626', fontSize: '18px' }}>✓</div>
        )}
    </motion.div>
);
