import React from 'react';
import { motion } from 'framer-motion';

export const Background = () => (
    <div style={{ position: 'absolute', inset: 0, overflow: 'hidden' }}>
        <motion.div
            animate={{ x: [0, 20, 0], y: [0, -15, 0], rotate: [0, 2, 0] }}
            transition={{ duration: 25, repeat: Infinity, ease: "easeInOut" }}
            style={{
                position: 'absolute',
                top: '8%',
                left: '12%',
                width: '60px',
                height: '60px',
                background: 'rgba(220, 38, 38, 0.08)',
                borderRadius: '8px',
                transform: 'rotate(15deg)'
            }}
        />
        <motion.div
            animate={{ x: [0, -18, 0], y: [0, 12, 0], rotate: [0, -2, 0] }}
            transition={{ duration: 30, repeat: Infinity, ease: "easeInOut", delay: 8 }}
            style={{
                position: 'absolute',
                top: '65%',
                right: '15%',
                width: '40px',
                height: '40px',
                background: 'rgba(220, 38, 38, 0.06)',
                borderRadius: '6px',
                transform: 'rotate(25deg)'
            }}
        />
        <motion.div
            animate={{ scale: [1, 1.1, 1], opacity: [0.3, 0.5, 0.3] }}
            transition={{ duration: 20, repeat: Infinity, ease: "easeInOut" }}
            style={{
                position: 'absolute',
                top: '20%',
                right: '25%',
                width: '80px',
                height: '80px',
                background: 'radial-gradient(circle, rgba(255, 255, 255, 0.4) 0%, transparent 70%)',
                borderRadius: '50%'
            }}
        />
    </div>
);
