import React from 'react';
import { isSmallScreen, isMediumScreen } from '../../utils/helpers';

export const Container = ({ children }) => {
    const containerStyle = {
        // minHeight: '100vh',
        background: 'linear-gradient(135deg, #ffffff 0%, #f8fafc 50%, #ffffff 100%)',
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center',
        padding: isSmallScreen() ? '20px' : '32px',
        position: 'relative',
        overflow: 'hidden',
        fontFamily: 'system-ui, -apple-system, sans-serif'
    };

    const maxWidthStyle = {
        // maxWidth: isSmallScreen() ? '340px' : isMediumScreen() ? '480px' : '540px',
        width: '100%',
        position: 'relative',
        zIndex: 10
    };

    return (
        <div style={containerStyle}>
            <div style={maxWidthStyle}>
                {children}
            </div>
        </div>
    );
};
