import React from 'react';
import { motion } from 'framer-motion';
import { EuiPanel, EuiTitle, EuiText, EuiSpacer, EuiProgress, EuiLoadingSpinner } from '../ui';
import { animations } from '../../utils/animations';
import { isSmallScreen } from '../../utils/helpers';

import getDict from '@/lib/dict';

const dict = getDict("de");
export const LoadingScreen = ({ text }) => {
    const [progress, setProgress] = React.useState(0);

    const isSmall = React.useMemo(() => isSmallScreen(), []);

    React.useEffect(()=>{
        const interval = setInterval(async () => {
        setProgress((prev) => {
            if (prev >= 100) {
                clearInterval(interval);
                return 100;
            }
            return prev + Math.random() * 8 + 2;
        });
        }, 150);
    },[])
    

    
    return (
        <motion.div
            key="loading"
            variants={animations.pageVariants}
            initial="initial"
            animate="in"
            exit="out"
        >
            <motion.div
                variants={animations.containerVariants}
                initial="hidden"
                animate="visible"
            >
                <EuiPanel paddingSize="l" style={{margin: '0 12px', textAlign: 'center'}}>
                    <motion.div
                        variants={animations.itemVariants}
                        style={{
                            fontSize: isSmall ? '40px' : '48px',
                            marginBottom: isSmall ? '16px' : '20px',
                            boxShadow: '0 2px 4px rgba(0,0,0,0.1)'
                        }}
                    >
                        📡
                    </motion.div>

                    <motion.div variants={animations.itemVariants}>
                        <EuiTitle size="m">{text}</EuiTitle>
                    </motion.div>

                    <EuiSpacer size="s"/>

                    <motion.div variants={animations.itemVariants}>
                        <EuiText color="subdued" size="s">
                            {dict.wait}...
                        </EuiText>
                    </motion.div>

                    <EuiSpacer size="l"/>

                    <div>
                        <EuiProgress value={progress} max={100}/>
                    </div>

                    <EuiSpacer size="m"/>

                    <motion.div variants={animations.itemVariants}
                                style={{display: 'flex', justifyContent: 'center', alignItems: 'center', gap: '12px'}}>
                        <EuiLoadingSpinner size="m"/>
                        <EuiText size="s" style={{fontWeight: '500', color: '#dc2626'}}>
                            {Math.round(progress)}%
                        </EuiText>
                    </motion.div>
                </EuiPanel>
            </motion.div>
        </motion.div>
    );
}
