import React from 'react';
import { motion, animations } from 'framer-motion';
import { EuiPanel, EuiTitle, EuiText, EuiSpacer, EuiProgress, EuiLoadingSpinner, EuiButton } from '../ui';
import { ProjectTypeCard } from '../forms/ProjectTypeCard';
import getDict from '@/lib/dict';
const dict = getDict("de");
export const ProjectSetupScreen = ({ projectName, setProjectName, onContinue }) => (
    <motion.div
        key="project-modal"
        variants={animations.pageVariants}
        initial="initial"
        animate="in"
        exit="out"
    >
        <motion.div
            variants={animations.containerVariants}
            initial="hidden"
            animate="visible"
        >
            <EuiPanel paddingSize="l" style={{ margin: '0 12px' }}>
                <motion.div variants={animations.itemVariants} style={{ textAlign: 'center', marginBottom: '28px' }}>
                    <EuiTitle size="m">{dict.finalStep}</EuiTitle>
                    <EuiSpacer size="s" />
                </motion.div>

                <motion.div variants={animations.itemVariants} style={{ marginBottom: '24px' }}>
                    <EuiText style={{ fontWeight: '600', marginBottom: '8px' }}>
                        {dict.projectNameText}
                    </EuiText>
                    <input
                        type="text"
                        value={projectName}
                        onChange={(e) => setProjectName(e.target.value)}
                        placeholder={dict.projectNameText}
                        style={{
                            width: '100%',
                            padding: '12px 16px',
                            borderRadius: '8px',
                            border: '2px solid #e5e7eb',
                            fontSize: '16px',
                            fontFamily: 'system-ui, -apple-system, sans-serif',
                            transition: 'border-color 0.2s ease',
                            outline: 'none',
                            boxSizing: 'border-box'
                        }}
                        onFocus={(e) => {
                            e.target.style.borderColor = '#dc2626';
                        }}
                        onBlur={(e) => {
                            e.target.style.borderColor = '#e5e7eb';
                        }}
                    />
                </motion.div>

                <motion.div variants={animations.itemVariants} style={{ textAlign: 'center' }}>
                    <div style={{ display: 'flex', gap: '12px', justifyContent: 'center' }}>
                        <EuiButton
                            fill
                            onClick={onContinue}
                            disabled={!projectName.trim()}
                        >
                            {dict.continue}
                        </EuiButton>
                    </div>
                </motion.div>
            </EuiPanel>
        </motion.div>
    </motion.div>
);
