import { EuiFlexItem, EuiIcon, EuiFlexGroup, EuiToolTip, EuiText, EuiPanel, EuiPopover } from '@elastic/eui';

import getDict from '@/lib/dict';
import { useState } from 'react';

const dict = getDict("de");

export const AccessPointLayer = ({ accessPointTypes, rotation, currentPageAccessPoints, editingNodeId, allowNodeMovement, zoomLevel, handleAccessPointDragStart, startEditingNode, showNodeDetails, handleTouchStartAccessPoint }) => {
    const [contextMenuNodeId, setContextMenuNodeId] = useState(null);

    return <div style={{
        position: 'absolute',
        inset: 0,
        pointerEvents: 'none',
        transform: `rotate(${rotation}deg)`,
        transformOrigin: 'center center'
    }}>
        {

            currentPageAccessPoints.map((ap) => {
                const accessPoint = accessPointTypes.find(t => t.id === ap.type);
                const isEditing = editingNodeId === ap.id;

                return (
                    <div
                        key={ap.id}
                        style={{
                            position: 'absolute',
                            left: `${ap.x}px`,
                            top: `${ap.y}px`,
                            transform: `translate(-50%, -50%) scale(${1 / zoomLevel})`,
                            pointerEvents: 'auto',
                            cursor: isEditing ? 'default' : (allowNodeMovement ? 'grab' : 'pointer'),
                            zIndex: 50,
                            touchAction: isEditing ? 'auto' : 'none'
                        }}
                        draggable={!isEditing}
                        onDragStart={(e) => !isEditing && handleAccessPointDragStart(e, ap)}
                        onTouchStart={(e) => !isEditing && handleTouchStartAccessPoint(e, ap)}
                        onMouseDown={(e) => e.stopPropagation()}
                    >
                        <EuiPopover
                            id={`contextMenu-${ap.id}`}
                            isOpen={contextMenuNodeId === ap.id}
                            closePopover={() => setContextMenuNodeId(null)}
                            button={
                                <EuiToolTip
                                    content={
                                        isEditing ? "Editing name..." : (
                                            <div>
                                                <div style={{ fontWeight: 'bold', marginBottom: '4px' }}>{ap.name}</div>
                                            </div>
                                        )
                                    }
                                    position="top"
                                >
                                    <div

                                        onContextMenu={(e) => {
                                            e.preventDefault();
                                            setContextMenuNodeId(ap.id);
                                        }}
                                        onDoubleClick={() => startEditingNode(ap)}
                                        onClick={() => !isEditing && showNodeDetails(ap)}
                                    >
                                        <div style={{ display: 'flex', alignItems: 'center', gap: '10px' }}>
                                            {/* Mini crosshair preview */}
                                            <div style={{ position: 'relative', width: '20px', height: '20px', flexShrink: 0 }}>
                                                {/* Outer circle */}
                                                <div
                                                    style={{
                                                        width: '20px',
                                                        height: '20px',
                                                        backgroundColor: accessPoint?.online ? '#10b981' : '#ef4444',
                                                        borderRadius: '50%',
                                                        border: '1px solid white',
                                                        boxShadow: '0 1px 3px rgba(0,0,0,0.3)'
                                                    }}
                                                />
                                                {/* Inner white circle */}
                                                <div
                                                    style={{
                                                        position: 'absolute',
                                                        top: '4px',
                                                        left: '4px',
                                                        width: '12px',
                                                        height: '12px',
                                                        backgroundColor: 'white',
                                                        borderRadius: '50%'
                                                    }}
                                                />
                                                {/* Center dot */}
                                            <div
                                                style={{
                                                    position: 'absolute',
                                                        top: '7px',
                                                        left: '7px',
                                                        width: '6px',
                                                        height: '6px',
                                                        backgroundColor: accessPoint?.online ? '#10b981' : '#ef4444',
                                                        borderRadius: '50%'
                                                    }}
                                                />
                                                {/* Mini crosshairs */}
                                                <div
                                                    style={{
                                                        position: 'absolute',
                                                        top: '9px',
                                                        left: '0px',
                                                        width: '20px',
                                                        height: '2px',
                                                        backgroundColor: 'none',
                                                        opacity: 0.8
                                                    }}
                                                />
                                                <div
                                                    style={{
                                                        position: 'absolute',
                                                        top: '0px',
                                                        left: '9px',
                                                        width: '2px',
                                                        height: '20px',
                                                        backgroundColor: 'none',
                                                        opacity: 0.8
                                                    }}
                                                />
                                            </div>
                                        </div>
                                    </div>
                                </EuiToolTip>
                            }
                            panelPaddingSize="none"
                            anchorPosition="downCenter"
                        >
                        </EuiPopover>

                    </div>
                );
            })}
    </div>
}
