import { EuiFlexItem, EuiIcon, EuiFlexGroup, EuiText, EuiPanel } from '@elastic/eui';

import getDict from '@/lib/dict';

const dict = getDict("de");

export const DropZoneIndicator = ({ accessPointTypes, draggedItem }) => {
    return <div
        style={{
            position: 'absolute',
            inset: 0,
            backgroundColor: 'rgba(0, 107, 180, 0.1)',
            border: '2px dashed #006BB4',
            borderRadius: '6px',
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'center',
            pointerEvents: 'none',
            zIndex: 40
        }}
    >
        <EuiPanel paddingSize="m" color="primary">
            <EuiFlexGroup alignItems="center" gutterSize="s">
                <EuiFlexItem grow={false}>
                    <EuiIcon type="pin" />
                </EuiFlexItem>
                <EuiFlexItem grow={false}>
                    <EuiText>
                        Drop here to add {accessPointTypes.find(t => t.id === draggedItem.type)?.name || dict.accessPoint}
                    </EuiText>
                </EuiFlexItem>
            </EuiFlexGroup>
        </EuiPanel>
    </div>
}
