import { animations } from "@/setupApp/utils/animations";
import { EuiPanel, EuiText, EuiSpacer } from '@elastic/eui';
import { AnimatePresence, motion } from 'framer-motion';
import { EuiTitle, EuiButton } from '@/setupApp/components/ui';
import { SCREEN_TYPES } from "@/setupApp/utils/constants";
import { useScreenManager } from "@/setupApp/hooks/useScreenManager";
import getDict from '@/lib/dict';
const dict = getDict("de");
export const Error = ({ loadingError, step }) => {
    const { navigateTo, isCurrentScreen } = useScreenManager();
  return (
      <motion.div
      key="failed"
      variants={animations.itemVariants}
      initial="initial"
      animate="in"
      exit="out"
  >
      <motion.div
          variants={animations.itemVariants}
          initial="hidden"
          animate="visible"
      >
          <EuiPanel paddingSize="l" style={{ margin: '0 12px', textAlign: 'center' }}>
              <motion.div
                  variants={animations.itemVariants}
                  initial={{ scale: 0, rotate: 0 }}
                  animate={{
                      scale: [1, 1.1, 0.9, 1],
                      rotate: [0, -5, 5, 0]
                  }}
                  transition={{
                      duration: 0.6,
                      times: [0, 0.3, 0.7, 1],
                      delay: 0.2
                  }}
                  style={{
                      fontSize: window.innerWidth < 640 ? '56px' : '72px',
                      marginBottom: window.innerWidth < 640 ? '20px' : '24px',
                      filter: 'drop-shadow(0 4px 12px rgba(220, 38, 38, 0.3))'
                  }}
              >
                  ❌
              </motion.div>

              <motion.div variants={animations.itemVariants}>
                  <EuiTitle size="l" style={{ color: '#dc2626' }}>
                      Achtung
                  </EuiTitle>
              </motion.div>

              <EuiSpacer size="s" />

              <motion.div variants={animations.itemVariants}>
                  <EuiText color="subdued" style={{ padding: '0 12px' }}>
                      {dict.apFetchToastFail}

                  </EuiText>
              </motion.div>

              <EuiSpacer size="l" />

              <motion.div
                  variants={animations.itemVariants}
                  style={{
                      padding: '20px',
                      backgroundColor: 'rgba(220, 38, 38, 0.1)',
                      borderRadius: '12px',
                      border: '1px solid rgba(220, 38, 38, 0.2)',
                      marginBottom: '24px'
                  }}
              >
                  <motion.div
                      initial={{ x: 0 }}
                      animate={{ x: [-2, 2, -2, 2, 0] }}
                      transition={{ duration: 0.5, delay: 0.5 }}
                      style={{ display: 'flex', alignItems: 'center', gap: '12px', justifyContent: 'center' }}
                  >
                      <div style={{ fontSize: '24px' }}>⚠️</div>
                      <div>
                          <EuiText style={{ fontWeight: '600', marginBottom: '4px', color: '#dc2626' }}>
                              Connection Error
                          </EuiText>
                          <EuiText size="s" color="subdued">
                              {loadingError}
                          </EuiText>
                      </div>
                  </motion.div>
              </motion.div>

              <motion.div variants={animations.itemVariants}>
                  <div style={{ display: 'flex', gap: '12px', justifyContent: 'center', flexWrap: 'wrap' }}>
                      <EuiButton
                          fill
                          onClick={() => navigateTo(step)}
                          style={{
                              backgroundColor: '#dc2626',
                              borderColor: '#dc2626'
                          }}
                          onMouseEnter={(e) => {
                              e.target.style.backgroundColor = '#b91c1c';
                          }}
                          onMouseLeave={(e) => {
                              e.target.style.backgroundColor = '#dc2626';
                          }}
                      >
                          Back
                      </EuiButton>
                  </div>
              </motion.div>
          </EuiPanel>
      </motion.div>
  </motion.div>)
}
