import React from 'react';
import { motion } from 'framer-motion';

export const EuiButton = ({ children, onClick, fill, disabled, fullWidth, style = {}, ...props }) => (
    <motion.button
        onClick={onClick}
        disabled={disabled}
        whileHover={!disabled ? { scale: 1.02 } : {}}
        whileTap={!disabled ? { scale: 0.98 } : {}}
        style={{
            backgroundColor: fill ? (disabled ? '#a0aec0' : '#dc2626') : 'white',
            color: fill ? 'white' : (disabled ? '#a0aec0' : '#dc2626'),
            border: fill ? 'none' : `2px solid ${disabled ? '#a0aec0' : '#dc2626'}`,
            padding: '14px 28px',
            fontSize: '16px',
            width: fullWidth ? '100%' : 'auto',
            borderRadius: '8px',
            fontWeight: '600',
            cursor: disabled ? 'not-allowed' : 'pointer',
            transition: 'all 0.3s cubic-bezier(0.4, 0, 0.2, 1)',
            boxShadow: fill && !disabled ? '0 4px 14px 0 rgba(220, 38, 38, 0.25)' : '0 2px 8px 0 rgba(220, 38, 38, 0.15)',
            fontFamily: 'system-ui, -apple-system, sans-serif',
            letterSpacing: '0.025em',
            opacity: disabled ? 0.6 : 1,
            ...style
        }}
        {...props}
    >
        {children}
    </motion.button>
);
