import React from 'react';
import { motion } from 'framer-motion';
import { isSmallScreen } from '../../utils/helpers';

export const EuiLoadingSpinner = ({ size = 'm', style = {}, ...props }) => (
    <motion.div
        animate={{ rotate: 360 }}
        transition={{ duration: 1.2, repeat: Infinity, ease: "linear" }}
        style={{
            width: size === 's' ? '18px' : size === 'm' ? (isSmallScreen() ? '24px' : '28px') : '36px',
            height: size === 's' ? '18px' : size === 'm' ? (isSmallScreen() ? '24px' : '28px') : '36px',
            border: '3px solid #f3f4f6',
            borderTop: '3px solid #dc2626',
            borderRadius: '50%',
            ...style
        }}
        {...props}
    />
);
