import React from 'react';
import { motion } from 'framer-motion';

export const EuiPanel = ({ children, paddingSize = 'm', style = {}, ...props }) => (
    <motion.div
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.4, ease: [0.4, 0, 0.2, 1] }}
        style={{
            backgroundColor: 'rgba(255, 255, 255, 0.95)',
            backdropFilter: 'blur(20px)',
            border: '1px solid rgba(255, 255, 255, 0.3)',
            borderRadius: '16px',
            padding: paddingSize === 's' ? '20px' : paddingSize === 'm' ? '28px' : '36px',
            boxShadow: '0 20px 40px -12px rgba(0, 0, 0, 0.08), 0 8px 16px -8px rgba(0, 0, 0, 0.06)',
            ...style
        }}
        {...props}
    >
        {children}
    </motion.div>
);
