import React from 'react';
import { motion } from 'framer-motion';

export const EuiProgress = ({ value, max = 100, style = {}, ...props }) => (
    <div style={{
        width: '100%',
        backgroundColor: '#f3f4f6',
        borderRadius: '12px',
        overflow: 'hidden',
        height: '8px',
        ...style
    }}>
        <motion.div
            style={{
                height: '100%',
                borderRadius: '12px',
                background: 'linear-gradient(135deg, #dc2626 0%, #b91c1c 100%)',
                boxShadow: '0 2px 8px rgba(220, 38, 38, 0.3)',
            }}
            initial={{ width: 0 }}
            animate={{ width: `${(value / max) * 100}%` }}
            transition={{ duration: 0.4, ease: [0.4, 0, 0.2, 1] }}
        />
    </div>
);
