import React from 'react';

export const EuiText = ({ children, size = 'm', color = 'default', style = {}, ...props }) => (
    <p
        style={{
            color: color === 'subdued' ? '#6b7280' : color === 'success' ? '#059669' : color === 'warning' ? '#d97706' : '#374151',
            fontSize: size === 's' ? '14px' : '16px',
            margin: 0,
            lineHeight: '1.6',
            fontFamily: 'system-ui, -apple-system, sans-serif',
            ...style
        }}
        {...props}
    >
        {children}
    </p>
);
