import React from 'react';
import { isSmallScreen } from '../../utils/helpers';

export const EuiTitle = ({ children, size = 'm', style = {}, ...props }) => (
    <h1
        style={{
            fontWeight: '700',
            color: '#1f2937',
            fontSize: size === 's' ? '22px' : size === 'm' ? (isSmallScreen() ? '26px' : '32px') : (isSmallScreen() ? '32px' : '40px'),
            margin: 0,
            fontFamily: 'system-ui, -apple-system, sans-serif',
            letterSpacing: '-0.025em',
            lineHeight: '1.2',
            ...style
        }}
        {...props}
    >
        {children}
    </h1>
);
