import { EuiFlexItem, EuiSwitch, EuiFlexGroup } from '@elastic/eui';
import getDict from '@/lib/dict';
const dict = getDict("de");

export const NodeMovementToggle = ({ allowNodeMovement, setAllowNodeMovement }) => {
    return <EuiFlexItem grow={false}>
        <EuiFlexGroup alignItems="center" gutterSize="s">
            <EuiFlexItem grow={false}>
                <EuiSwitch
                    label={dict.allowMoving}
                    checked={allowNodeMovement}
                    onChange={(e: { target: { checked: boolean; }; }) => setAllowNodeMovement(e.target.checked)}
                    compressed
                />
            </EuiFlexItem>
        </EuiFlexGroup>
    </EuiFlexItem>
}
