import { EuiFlexItem, EuiToolTip, EuiButtonIcon } from '@elastic/eui';

export const RotationComponent = ({ text, handleRotation }) => {
    return <EuiFlexItem grow={false}>
        <EuiToolTip content={text}>
            <EuiButtonIcon
                iconType={"returnKey"}
                onClick={handleRotation}
                aria-label={text}
                style={{ transform: text === 'Rotate Left' ? 'scaleX(-1)' : 'none' }}
            />
        </EuiToolTip>
    </EuiFlexItem>
}
