import { EuiFlexItem, EuiToolTip, EuiButtonIcon } from '@elastic/eui';

export const ZoomComponent = ({ text, handleZoom, disabledCondition }) => {
    return <EuiFlexItem grow={false}>
        <EuiToolTip content={text}>
            <EuiButtonIcon
                iconType={ text === 'Zoom Out' ? "minusInCircle" : 'plusInCircle'}
                onClick={handleZoom}
                disabled={disabledCondition}
                aria-label={text}
            />
        </EuiToolTip>
    </EuiFlexItem>
}
