import Network from '@/app/types/Network';
import { apiFetch } from '@/lib/api';
import { useState } from 'react';

export const useNetworkManager = () => {
    const [networkName, setNetworkName] = useState('');
    const [networkType, setNetworkType] = useState('');
    const [savedProjects, setSavedProjects] = useState([]);
    const [showSaveModal, setShowSaveModal] = useState(false);
    const [showLoadModal, setShowLoadModal] = useState(false);
    const [apiLoading, setApiLoading] = useState(false);
    const [saved, setSaved] = useState(false);

    const saveNetwork = async (data) => {
        try {
            setApiLoading(true);
            const response = await apiFetch(`/networks`, {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify(data),
            });
            if (response.ok) {
                const data: Network = await response.json();
                setShowSaveModal(false);
                setNetworkName('');
                setSaved(true);
            } else {
                setSaved(false);
                return;
            }
        } catch (error) {
            console.error('Error saving :', error);
            setSaved(false);
            throw error;
        } finally {
            setApiLoading(false);
        }
    };

    return {
        networkName,
        setNetworkName,
        networkType,
        setNetworkType,
        savedProjects,
        setSavedProjects,
        showSaveModal,
        setShowSaveModal,
        showLoadModal,
        setShowLoadModal,
        apiLoading,
        setApiLoading,
        saveNetwork,
        saved
    };
};
