import { useState, useCallback } from 'react';

export const useProjectLoader = () => {
    const [loading, setLoading] = useState(false);
    const [progress, setProgress] = useState(0);
    const [projects, setProjects] = useState([]);
    const [completed, setCompleted] = useState(false);
    const loadProjects = useCallback(() => {
        setLoading(true);
        setProgress(0);
        setCompleted(false);

        const interval = setInterval(async () => {
            setProgress((prev) => {
                if (prev >= 100) {
                    clearInterval(interval);
                    setLoading(false);
                    setCompleted(true);
                    return 100;
                }
                return prev + Math.random() * 8 + 2;
            });
        }, 150);

        return interval;
    }, []);

    const reset = useCallback(() => {
        setLoading(false);
        setProgress(0);
        setProjects([]);
        setCompleted(false);
    }, []);

    return { loading, progress, projects, completed, loadProjects, reset, setProgress };
};
